/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.stats.ThrownStore;

public class MethodExecStats {
    private final long guid;
    private final Method method;
    private final ThrownStore thrownStore;
    private final AtomicInteger maxTime = new AtomicInteger();
    private final AtomicInteger minTime = new AtomicInteger(-1);
    private AtomicInteger starts = new AtomicInteger();
    private AtomicInteger finishes = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();
    private AtomicLong totalTime = new AtomicLong();

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected MethodExecStats(Builder builder) {
        this.guid = new Random().nextLong();
        this.method = builder.method;
        this.thrownStore = Utils.nn(builder.thrownStore) ? builder.thrownStore : new ThrownStore();
    }

    public MethodExecStats error(Throwable e) {
        this.errors.incrementAndGet();
        this.thrownStore.add(e);
        return this;
    }

    public MethodExecStats finished(long nanoTime) {
        this.finishes.incrementAndGet();
        int milliTime = (int)(nanoTime / 1000000L);
        this.totalTime.addAndGet(nanoTime);
        int currentMin = this.minTime.get();
        if (currentMin == -1) {
            this.minTime.compareAndSet(-1, milliTime);
        } else {
            this.minTime.updateAndGet(x -> Math.min(x, milliTime));
        }
        this.maxTime.updateAndGet(x -> Math.max(x, milliTime));
        return this;
    }

    public int getAvgTime() {
        int runs = this.finishes.get();
        return runs == 0 ? 0 : (int)(this.getTotalTime() / (long)runs);
    }

    public int getErrors() {
        return this.errors.get();
    }

    public long getGuid() {
        return this.guid;
    }

    public int getMaxTime() {
        return this.maxTime.get();
    }

    public Method getMethod() {
        return this.method;
    }

    public int getMinTime() {
        int value = this.minTime.get();
        return value == -1 ? 0 : value;
    }

    public int getRunning() {
        return this.starts.get() - this.finishes.get();
    }

    public int getRuns() {
        return this.starts.get();
    }

    public ThrownStore getThrownStore() {
        return this.thrownStore;
    }

    public long getTotalTime() {
        return this.totalTime.get() / 1000000L;
    }

    public MethodExecStats started() {
        this.starts.incrementAndGet();
        return this;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("avgTime", this.getAvgTime()).a("errors", this.getErrors()).a("guid", this.guid).a("maxTime", this.getMaxTime()).a("method", this.method).a("minTime", this.getMinTime()).a("running", this.getRunning()).a("runs", this.getRuns()).a("thrownStore", this.thrownStore).a("totalTime", this.getTotalTime());
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    public static class Builder
    extends BeanBuilder<MethodExecStats> {
        Method method;
        ThrownStore thrownStore;

        protected Builder(BeanStore beanStore) {
            super(MethodExecStats.class, beanStore);
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder method(Method value) {
            this.method = value;
            return this;
        }

        public Builder thrownStore(ThrownStore value) {
            this.thrownStore = value;
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected MethodExecStats buildDefault() {
            return new MethodExecStats(this);
        }
    }
}

