/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.csv.CsvSerializer;
import org.apache.juneau.csv.CsvWriter;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;

public class CsvSerializerSession
extends WriterSerializerSession {
    public static Builder create(CsvSerializer ctx) {
        return new Builder(AssertionUtils.assertArgNotNull("ctx", ctx));
    }

    protected CsvSerializerSession(Builder builder) {
        super(builder);
    }

    private Object applySwap(Object value, ClassMeta<?> type) {
        try {
            if (value == null || type == null) {
                return value;
            }
            ObjectSwap<?, ?> swap = type.getSwap(this);
            if (Utils.nn(swap)) {
                return this.swap(swap, value);
            }
            return value;
        }
        catch (SerializeException e) {
            throw ThrowableUtils.rex(e);
        }
    }

    @Override
    protected void doSerialize(SerializerPipe pipe, Object o) throws IOException, SerializeException {
        try (CsvWriter w = this.getCsvWriter(pipe);){
            ClassMeta<Object> cm = this.getClassMetaForObject(o);
            Collection<Object> l = null;
            l = cm.isArray() ? CollectionUtils.l((Object[])o) : (cm.isCollection() ? (Collection)o : Collections.singleton(o));
            if (Utils.ne(l)) {
                ClassMeta<Object> entryType = this.getClassMetaForObject(l.iterator().next());
                if (entryType.isBean()) {
                    BeanMeta<Object> bm = entryType.getBeanMeta();
                    Flag addComma = Flag.create();
                    bm.getProperties().values().stream().filter(BeanPropertyMeta::canRead).forEach(x -> {
                        addComma.ifSet(() -> w.w(',')).set();
                        w.writeEntry(x.getName());
                    });
                    w.append('\n');
                    l.forEach(x -> {
                        Flag addComma2 = Flag.create();
                        BeanMap<Object> bean = this.toBeanMap(x);
                        bm.getProperties().values().stream().filter(BeanPropertyMeta::canRead).forEach(y -> {
                            addComma2.ifSet(() -> w.w(',')).set();
                            Object value = y.get(bean, y.getName());
                            w.writeEntry(value);
                        });
                        w.w('\n');
                    });
                } else if (entryType.isMap()) {
                    Flag addComma = Flag.create();
                    Map first = (Map)l.iterator().next();
                    first.keySet().forEach(x -> {
                        addComma.ifSet(() -> w.w(',')).set();
                        w.writeEntry(x);
                    });
                    w.append('\n');
                    l.stream().forEach(x -> {
                        Flag addComma2 = Flag.create();
                        Map map = (Map)x;
                        map.values().forEach(y -> {
                            addComma2.ifSet(() -> w.w(',')).set();
                            Object value = this.applySwap(y, this.getClassMetaForObject(y));
                            w.writeEntry(value);
                        });
                        w.w('\n');
                    });
                } else {
                    w.writeEntry("value");
                    w.append('\n');
                    l.stream().forEach(x -> {
                        Object value = this.applySwap(x, this.getClassMetaForObject(x));
                        w.writeEntry(value);
                        w.w('\n');
                    });
                }
            }
        }
    }

    CsvWriter getCsvWriter(SerializerPipe out) {
        Object output = out.getRawOutput();
        if (output instanceof CsvWriter) {
            CsvWriter output2 = (CsvWriter)output;
            return output2;
        }
        CsvWriter w = new CsvWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.getQuoteChar(), this.isTrimStrings(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    public static class Builder
    extends WriterSerializerSession.Builder {
        protected Builder(CsvSerializer ctx) {
            super(AssertionUtils.assertArgNotNull("ctx", ctx));
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public CsvSerializerSession build() {
            return new CsvSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

