/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Version;
import org.apache.juneau.commons.utils.Utils;

public class VersionRange {
    private final Version minVersion;
    private final Version maxVersion;
    private final boolean minExclusive;
    private final boolean maxExclusive;

    public VersionRange(String range) {
        range = range.trim();
        if (!range.isEmpty()) {
            char c1 = range.charAt(0);
            char c2 = range.charAt(range.length() - 1);
            int c = range.indexOf(44);
            if (!(c <= -1 || c1 != '[' && c1 != '(' || c2 != ']' && c2 != ')')) {
                String v1 = range.substring(1, c);
                String v2 = range.substring(c + 1, range.length() - 1);
                this.minVersion = new Version(v1);
                this.maxVersion = new Version(v2);
                this.minExclusive = c1 == '(';
                this.maxExclusive = c2 == ')';
            } else {
                this.minVersion = new Version(range);
                this.maxVersion = null;
                this.maxExclusive = false;
                this.minExclusive = false;
            }
        } else {
            this.maxVersion = null;
            this.minVersion = null;
            this.maxExclusive = false;
            this.minExclusive = false;
        }
    }

    public boolean matches(String v) {
        if (Utils.e(v)) {
            return this.minVersion == null && this.maxVersion == null;
        }
        Version ver = new Version(v);
        return (!Utils.nn(this.minVersion) || ver.isAtLeast(this.minVersion, this.minExclusive)) && (!Utils.nn(this.maxVersion) || ver.isAtMost(this.maxVersion, this.maxExclusive));
    }

    public String toString() {
        return (this.minExclusive ? "(" : "[") + String.valueOf(this.minVersion) + "," + String.valueOf(this.maxVersion) + (this.maxExclusive ? ")" : "]");
    }
}

