/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.MediaType;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class RequestBodyInfo
extends OpenApiElement {
    private String description;
    private Map<String, MediaType> content = CollectionUtils.map();
    private Boolean required;

    public RequestBodyInfo() {
    }

    public RequestBodyInfo(RequestBodyInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.required = copyFrom.required;
        if (Utils.nn(copyFrom.content)) {
            this.content.putAll(CollectionUtils.copyOf(copyFrom.content, MediaType::copy));
        }
    }

    public RequestBodyInfo addContent(String key, MediaType value) {
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        this.content.put(key, value);
        return this;
    }

    public RequestBodyInfo copy() {
        return new RequestBodyInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "content" -> ConverterUtils.toType(this.getContent(), type);
            case "required" -> ConverterUtils.toType((Object)this.getRequired(), type);
            default -> super.get(property, type);
        });
    }

    public Map<String, MediaType> getContent() {
        return Utils.nullIfEmpty(this.content);
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.ne(this.content), (Object)"content").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.required), (Object)"required").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public RequestBodyInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "content" -> this.setContent(ConverterUtils.toMapBuilder((Object)value, String.class, MediaType.class).sparse().build());
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "required" -> this.setRequired(ConverterUtils.toBoolean((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public RequestBodyInfo setContent(Map<String, MediaType> value) {
        this.content.clear();
        if (Utils.nn(value)) {
            this.content.putAll(value);
        }
        return this;
    }

    public RequestBodyInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public RequestBodyInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    @Override
    public RequestBodyInfo strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected RequestBodyInfo strict() {
        super.strict();
        return this;
    }
}

