/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.EntityTags;

public class BasicEntityTagsHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final EntityTags value;
    private final Supplier<EntityTags> supplier;

    public static BasicEntityTagsHeader of(String name, EntityTags value) {
        return value == null ? null : new BasicEntityTagsHeader(name, value);
    }

    public static BasicEntityTagsHeader of(String name, String value) {
        return value == null ? null : new BasicEntityTagsHeader(name, value);
    }

    public static BasicEntityTagsHeader of(String name, Supplier<EntityTags> value) {
        return value == null ? null : new BasicEntityTagsHeader(name, value);
    }

    public BasicEntityTagsHeader(String name, EntityTags value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicEntityTagsHeader(String name, String value) {
        super(name, value);
        this.value = EntityTags.of(value);
        this.supplier = null;
    }

    public BasicEntityTagsHeader(String name, Supplier<EntityTags> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<EntityTags> asEntityTags() {
        return Utils.opt((Object)this.value());
    }

    @Override
    public String getValue() {
        return Utils.s((Object)this.value());
    }

    public EntityTags orElse(EntityTags other) {
        EntityTags x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public EntityTags toEntityTags() {
        return this.value();
    }

    private EntityTags value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

