/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.juneau.assertions.Snippet;
import org.apache.juneau.internal.ExceptionBuilder;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;

public class ThrowableUtils {
    public static ExceptionBuilder<RuntimeException> runtimeException() {
        return new ExceptionBuilder<RuntimeException>(RuntimeException.class);
    }

    public static RuntimeException runtimeException(String msg, Object ... args) {
        return ThrowableUtils.runtimeException().message(msg, args).build();
    }

    public static RuntimeException runtimeException(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.runtimeException().message(msg, args).causedBy(cause).build();
    }

    public static RuntimeException runtimeException(Throwable cause) {
        return cause instanceof RuntimeException ? (RuntimeException)cause : ThrowableUtils.runtimeException().causedBy(cause).build();
    }

    public static ExceptionBuilder<IOException> ioException() {
        return new ExceptionBuilder<IOException>(IOException.class);
    }

    public static IOException ioException(String msg, Object ... args) {
        return ThrowableUtils.ioException().message(msg, args).build();
    }

    public static IOException ioException(Throwable cause, String msg, Object ... args) {
        return ThrowableUtils.ioException().message(msg, args).causedBy(cause).build();
    }

    public static IOException ioException(Throwable cause) {
        return cause instanceof IOException ? (IOException)cause : ThrowableUtils.ioException().causedBy(cause).build();
    }

    public static ExceptionBuilder<UnsupportedOperationException> unsupportedOperationException() {
        return new ExceptionBuilder<UnsupportedOperationException>(UnsupportedOperationException.class);
    }

    public static UnsupportedOperationException unsupportedOperationException(String msg, Object ... args) {
        return ThrowableUtils.unsupportedOperationException().message(msg, args).build();
    }

    public static ExceptionBuilder<IllegalArgumentException> illegalArgumentException() {
        return new ExceptionBuilder<IllegalArgumentException>(IllegalArgumentException.class);
    }

    public static IllegalArgumentException illegalArgumentException(String msg, Object ... args) {
        return ThrowableUtils.illegalArgumentException().message(msg, args).build();
    }

    public static ExceptionBuilder<SerializeException> serializeException() {
        return new ExceptionBuilder<SerializeException>(SerializeException.class);
    }

    public static SerializeException serializeException(String msg, Object ... args) {
        return ThrowableUtils.serializeException().message(msg, args).build();
    }

    public static SerializeException serializeException(Throwable cause) {
        return cause instanceof SerializeException ? (SerializeException)cause : ThrowableUtils.serializeException().causedBy(cause).build();
    }

    public static ExceptionBuilder<ParseException> parseException() {
        return new ExceptionBuilder<ParseException>(ParseException.class);
    }

    public static ParseException parseException(String msg, Object ... args) {
        return ThrowableUtils.parseException().message(msg, args).build();
    }

    public static ParseException parseException(Throwable cause) {
        return cause instanceof ParseException ? (ParseException)cause : ThrowableUtils.parseException().causedBy(cause).build();
    }

    public static <T extends Throwable> T getCause(Class<T> c, Throwable t) {
        while (t != null) {
            if (!c.isInstance(t = t.getCause())) continue;
            return (T)((Throwable)c.cast(t));
        }
        return null;
    }

    public static <T> T safeSupplier(SupplierWithThrowable<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw ThrowableUtils.runtimeException(t);
        }
    }

    public static void safeRun(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw ThrowableUtils.runtimeException(t);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    @FunctionalInterface
    public static interface SupplierWithThrowable<T> {
        public T get() throws Throwable;
    }
}

