/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.http.NameValuePair;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.httppart.RequestPathParam;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.svl.VarResolverSession;

public class RequestPathParams {
    private final RestSession session;
    private final RestRequest req;
    private final boolean caseSensitive;
    private HttpPartParserSession parser;
    private final VarResolverSession vs;
    private List<RequestPathParam> list = new LinkedList<RequestPathParam>();
    private Map<String, List<RequestPathParam>> map = new TreeMap<String, List<RequestPathParam>>();

    public RequestPathParams(RestSession session, RestRequest req, boolean caseSensitive) {
        this.session = session;
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Map parentVars = (Map)req.getAttribute("juneau.pathVars").orElse(Collections.emptyMap());
        for (Map.Entry entry : parentVars.entrySet()) {
            this.add((String)entry.getKey(), entry.getValue());
        }
        UrlPathMatch pm = session.getUrlPathMatch();
        if (pm != null) {
            for (Map.Entry<String, String> entry : pm.getVars().entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
            String string = pm.getRemainder();
            if (string != null) {
                this.add("/**", string);
                this.add("/*", StringUtils.urlDecode((String)string));
            }
        }
    }

    private RequestPathParams(RequestPathParams copyFrom) {
        this.session = copyFrom.session;
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.list.addAll(copyFrom.list);
        this.map.putAll(copyFrom.map);
        this.vs = copyFrom.vs;
    }

    public RequestPathParams parser(HttpPartParserSession value) {
        this.parser = value;
        for (RequestPathParam p : this.list) {
            p.parser(this.parser);
        }
        return this;
    }

    public RequestPathParams addDefault(List<NameValuePair> pairs) {
        for (NameValuePair p : pairs) {
            boolean hasAllBlanks;
            String name = p.getName();
            String key = this.key(name);
            List<RequestPathParam> l = this.map.get(key);
            boolean bl = hasAllBlanks = l != null && l.stream().allMatch(x -> StringUtils.isEmpty((String)x.getValue()));
            if (l != null && !hasAllBlanks) continue;
            if (hasAllBlanks) {
                this.list.removeAll(l);
            }
            RequestPathParam x2 = new RequestPathParam(this.req, name, this.vs.resolve(p.getValue()));
            this.list.add(x2);
            this.map.put(key, CollectionUtils.list((Object[])new RequestPathParam[]{x2}));
        }
        return this;
    }

    public RequestPathParams addDefault(NameValuePair ... pairs) {
        return this.addDefault(CollectionUtils.alist((Object[])pairs));
    }

    public List<RequestPathParam> getAll(String name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        List<RequestPathParam> l = this.map.get(this.key(name));
        return l == null ? CollectionUtils.emptyList() : CollectionUtils.unmodifiable(l);
    }

    public List<RequestPathParam> getAll() {
        return CollectionUtils.unmodifiable(this.list);
    }

    public boolean contains(String ... names) {
        Assertions.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (this.map.containsKey(this.key(n))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String ... names) {
        Assertions.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (!this.map.containsKey(this.key(n))) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public RequestPathParams add(String name, Object value) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        String key = this.key(name);
        RequestPathParam h = new RequestPathParam(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.map.get(key).add(h);
        } else {
            this.map.put(key, CollectionUtils.list((Object[])new RequestPathParam[]{h}));
        }
        this.list.add(h);
        return this;
    }

    public RequestPathParams add(NameValuePair ... parameters) {
        Assertions.assertArgNotNull((String)"parameters", (Object)parameters);
        for (NameValuePair p : parameters) {
            if (p == null) continue;
            this.add(p.getName(), p.getValue());
        }
        return this;
    }

    public RequestPathParams set(String name, Object value) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        String key = this.key(name);
        RequestPathParam p = new RequestPathParam(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.list.removeIf(x -> this.caseSensitive ? x.getName().equals(name) : x.getName().equalsIgnoreCase(name));
        }
        this.list.add(p);
        this.map.put(key, CollectionUtils.list((Object[])new RequestPathParam[]{p}));
        return this;
    }

    public RequestPathParams set(NameValuePair ... parameters) {
        Assertions.assertArgNotNull((String)"headers", (Object)parameters);
        for (NameValuePair p : parameters) {
            this.remove(p);
        }
        for (NameValuePair p : parameters) {
            this.add(p);
        }
        return this;
    }

    public RequestPathParams remove(String ... name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        for (String n : name) {
            String key = this.key(n);
            if (this.map.containsKey(key)) {
                this.list.removeAll((Collection)this.map.get(key));
            }
            this.map.remove(key);
        }
        return this;
    }

    public RequestPathParams remove(NameValuePair ... parameters) {
        for (NameValuePair p : parameters) {
            this.remove(p.getName());
        }
        return this;
    }

    public RequestPathParam getFirst(String name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        List<RequestPathParam> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestPathParam(this.req, name, null).parser(this.parser) : l.get(0);
    }

    public RequestPathParam getLast(String name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        List<RequestPathParam> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestPathParam(this.req, name, null).parser(this.parser) : l.get(l.size() - 1);
    }

    public RequestPathParam get(String name) {
        return this.getLast(name);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta cm = this.req.getBeanSession().getClassMeta(type);
        String name = (String)HttpParts.getName((HttpPartType)HttpPartType.PATH, (ClassMeta)cm).orElseThrow(() -> ThrowableUtils.runtimeException((String)"@Path(name) not found on class {0}", (Object[])new Object[]{ClassUtils.className((Object)type)}));
        return this.get(name).as(type);
    }

    public RequestPathParams copy() {
        return new RequestPathParams(this);
    }

    public RequestPathParam getRemainder() {
        return this.get("/*");
    }

    public RequestPathParam getRemainderUndecoded() {
        return this.get("/**");
    }

    public String toString(boolean sorted) {
        JsonMap m = JsonMap.create();
        if (sorted) {
            for (List<RequestPathParam> p1 : this.map.values()) {
                for (RequestPathParam p2 : p1) {
                    m.append(p2.getName(), (Object)p2.getValue());
                }
            }
        } else {
            for (RequestPathParam p : this.list) {
                m.append(p.getName(), (Object)p.getValue());
            }
        }
        return m.toString();
    }

    private String key(String name) {
        return this.caseSensitive ? name : name.toLowerCase();
    }

    public String toString() {
        return this.toString(false);
    }
}

