/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.json.annotation.Json;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class JsonAnnotation {
    public static final Json DEFAULT = JsonAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return JsonAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return JsonAnnotation.create().on(on);
    }

    public static Json copy(Json a, VarResolverSession r) {
        return ((Builder)JsonAnnotation.create().on(r.resolve(a.on())).onClass((Class[])a.onClass())).wrapperAttr(r.resolve(a.wrapperAttr())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Json[] value();
    }

    public static class Apply
    extends AnnotationApplier<Json, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Json.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Json> ai, Context.Builder b) {
            Json a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(JsonAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Json {
        private final String wrapperAttr;

        Impl(Builder b) {
            super(b);
            this.wrapperAttr = b.wrapperAttr;
            this.postConstruct();
        }

        @Override
        public String wrapperAttr() {
            return this.wrapperAttr;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        String wrapperAttr = "";

        protected Builder() {
            super(Json.class);
        }

        public Json build() {
            return new Impl(this);
        }

        public Builder wrapperAttr(String value) {
            this.wrapperAttr = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

