/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.HttpExceptionBuilder;

@Response
@StatusCode(value={505})
@Schema(description={"HTTP Version Not Supported"})
public class HttpVersionNotSupported
extends BasicHttpException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 505;
    public static final String REASON_PHRASE = "HTTP Version Not Supported";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(505).reasonPhrase("HTTP Version Not Supported").build();
    public static final HttpVersionNotSupported INSTANCE = (HttpVersionNotSupported)((HttpExceptionBuilder)HttpVersionNotSupported.create().unmodifiable()).build();

    public static HttpExceptionBuilder<HttpVersionNotSupported> create() {
        return new HttpExceptionBuilder<Class<HttpVersionNotSupported>>(HttpVersionNotSupported.class).statusLine(STATUS_LINE);
    }

    public HttpVersionNotSupported(HttpExceptionBuilder<?> builder) {
        super(builder);
    }

    public HttpVersionNotSupported(Throwable cause, String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)((HttpExceptionBuilder)HttpVersionNotSupported.create().causedBy(cause)).message(msg, args));
    }

    public HttpVersionNotSupported() {
        this(HttpVersionNotSupported.create());
    }

    public HttpVersionNotSupported(String msg) {
        this((HttpExceptionBuilder<?>)HttpVersionNotSupported.create().message(msg, new Object[0]));
    }

    public HttpVersionNotSupported(String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)HttpVersionNotSupported.create().message(msg, args));
    }

    public HttpVersionNotSupported(Throwable cause) {
        this((HttpExceptionBuilder<?>)HttpVersionNotSupported.create().causedBy(cause));
    }

    public HttpVersionNotSupported(HttpResponse response) {
        this(HttpVersionNotSupported.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpExceptionBuilder<HttpVersionNotSupported> copy() {
        return new HttpExceptionBuilder<HttpVersionNotSupported>(this);
    }
}

