/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Supplier;
import org.apache.juneau.http.entity.ByteArrayEntity;
import org.apache.juneau.http.entity.FileEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.http.entity.InputStreamEntity;
import org.apache.juneau.http.entity.ReaderEntity;
import org.apache.juneau.http.entity.SerializedEntity;
import org.apache.juneau.http.entity.SerializedEntityBuilder;
import org.apache.juneau.http.entity.StringEntity;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.Serializer;

public class HttpEntities {
    public static final HttpEntityBuilder<ByteArrayEntity> byteArrayEntity(byte[] content) {
        return ByteArrayEntity.create().content(content);
    }

    public static final HttpEntityBuilder<ByteArrayEntity> byteArrayEntity(byte[] content, ContentType contentType) {
        return ByteArrayEntity.create().content(content).contentType(contentType);
    }

    public static final HttpEntityBuilder<ByteArrayEntity> byteArrayEntity(Supplier<byte[]> content) {
        return ByteArrayEntity.create().content(content);
    }

    public static final HttpEntityBuilder<ByteArrayEntity> byteArrayEntity(Supplier<byte[]> content, ContentType contentType) {
        return ByteArrayEntity.create().content(content).contentType(contentType);
    }

    public static final HttpEntityBuilder<FileEntity> fileEntity(File content) {
        return FileEntity.create().content(content);
    }

    public static final HttpEntityBuilder<FileEntity> fileEntity(File content, ContentType contentType) {
        return FileEntity.create().content(content).contentType(contentType);
    }

    public static final HttpEntityBuilder<ReaderEntity> readerEntity(Reader content) {
        return ReaderEntity.create().content(content);
    }

    public static final HttpEntityBuilder<ReaderEntity> readerEntity(Reader content, ContentType contentType) {
        return ReaderEntity.create().content(content).contentType(contentType);
    }

    public static final SerializedEntityBuilder<SerializedEntity> serializedEntity(Object content, Serializer serializer) {
        return ((SerializedEntityBuilder)SerializedEntity.create().content(content)).serializer(serializer);
    }

    public static final SerializedEntityBuilder<SerializedEntity> serializedEntity(Supplier<?> content, Serializer serializer) {
        return ((SerializedEntityBuilder)SerializedEntity.create().content((Supplier)content)).serializer(serializer);
    }

    public static final SerializedEntityBuilder<SerializedEntity> serializedEntity(Object content, Serializer serializer, HttpPartSchema schema) {
        return ((SerializedEntityBuilder)SerializedEntity.create().content(content)).serializer(serializer).schema(schema);
    }

    public static final SerializedEntityBuilder<SerializedEntity> serializedEntity(Supplier<?> content, Serializer serializer, HttpPartSchema schema) {
        return ((SerializedEntityBuilder)SerializedEntity.create().content((Supplier)content)).serializer(serializer).schema(schema);
    }

    public static final HttpEntityBuilder<InputStreamEntity> streamEntity(InputStream content) {
        return InputStreamEntity.create().content(content);
    }

    public static final HttpEntityBuilder<InputStreamEntity> streamEntity(InputStream content, long length, ContentType contentType) {
        return InputStreamEntity.create().content(content).contentLength(length).contentType(contentType);
    }

    public static final HttpEntityBuilder<StringEntity> stringEntity(String content) {
        return StringEntity.create().content(content);
    }

    public static final HttpEntityBuilder<StringEntity> stringEntity(String content, ContentType contentType) {
        return StringEntity.create().content(content).contentType(contentType);
    }

    public static final HttpEntityBuilder<StringEntity> stringEntity(Supplier<String> content) {
        return StringEntity.create().content(content);
    }

    public static final HttpEntityBuilder<StringEntity> stringEntity(Supplier<String> content, ContentType contentType) {
        return StringEntity.create().content(content).contentType(contentType);
    }
}

