/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.remote;

import java.lang.reflect.Method;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;

public class RrpcInterfaceMethodMeta {
    private final String url;
    private final String path;
    private final Method method;

    public RrpcInterfaceMethodMeta(String restUrl, Method m) {
        this.method = m;
        this.path = m.getName() + '/' + RrpcInterfaceMethodMeta.getMethodArgsSignature(m);
        this.url = StringUtils.trimSlashes(restUrl) + '/' + StringUtils.urlEncode(this.path);
    }

    private static String getMethodArgsSignature(Method m) {
        StringBuilder sb = new StringBuilder(128);
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length == 0) {
            return "";
        }
        sb.append('(');
        for (int i = 0; i < pt.length; ++i) {
            ClassInfo pti = ClassInfo.of(pt[i]);
            if (i > 0) {
                sb.append(',');
            }
            pti.appendFullName(sb);
        }
        sb.append(')');
        return sb.toString();
    }

    public String getUri() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public Method getJavaMethod() {
        return this.method;
    }
}

