/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class BasicRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    final boolean unmodifiable;

    public static Builder create() {
        return new Builder();
    }

    public BasicRuntimeException(Builder builder) {
        super(builder.message, builder.causedBy);
        this.unmodifiable = builder.unmodifiable;
    }

    public BasicRuntimeException(Throwable cause, String message, Object ... args) {
        this(BasicRuntimeException.create().causedBy(cause).message(message, args));
    }

    public BasicRuntimeException(String message, Object ... args) {
        this(BasicRuntimeException.create().message(message, args));
    }

    public BasicRuntimeException(Throwable cause) {
        this(BasicRuntimeException.create().causedBy(cause));
    }

    public <T extends Throwable> T getCause(Class<T> c) {
        return ThrowableUtils.getCause(c, this);
    }

    @Override
    public String getMessage() {
        String m = super.getMessage();
        if (m == null && this.getCause() != null) {
            m = this.getCause().getMessage();
        }
        return m;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        this.assertModifiable();
        return super.fillInStackTrace();
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        this.assertModifiable();
        return super.initCause(cause);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.assertModifiable();
        super.setStackTrace(stackTrace);
    }

    public Throwable unwrap() {
        Throwable t = this.getCause();
        return t == null ? this : t;
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("Bean is read-only");
        }
    }

    @FluentSetters
    public static class Builder {
        String message;
        Throwable causedBy;
        boolean unmodifiable;

        protected Builder() {
        }

        protected Builder(BasicRuntimeException copyFrom) {
            this.message = copyFrom.getMessage();
            this.causedBy = copyFrom.getCause();
            this.unmodifiable = copyFrom.unmodifiable;
        }

        @FluentSetter
        public Builder message(String msg, Object ... args) {
            this.message = StringUtils.format(msg, args);
            return this;
        }

        @FluentSetter
        public Builder causedBy(Throwable value) {
            this.causedBy = value;
            return this;
        }

        @FluentSetter
        public Builder unmodifiable() {
            this.unmodifiable = true;
            return this;
        }

        public BasicRuntimeException build() {
            return new BasicRuntimeException(this);
        }
    }
}

