/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.function.Supplier;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.Headerable;
import org.apache.juneau.http.SerializedHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;

public class SerializedNameValuePair
extends BasicNameValuePair
implements Headerable {
    private final Object value;
    private HttpPartType type;
    private HttpPartSerializerSession serializer;
    private HttpPartSchema schema = HttpPartSchema.DEFAULT;
    private boolean skipIfEmpty;

    public static SerializedNameValuePair of(String name, Object value) {
        return new SerializedNameValuePair(name, value, null, null, null, false);
    }

    public static SerializedNameValuePair of(String name, Supplier<?> value) {
        return new SerializedNameValuePair(name, value, null, null, null, false);
    }

    public SerializedNameValuePair(String name, Object value, HttpPartType type, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        super(name, value);
        this.value = value;
        this.type = type;
        this.serializer = serializer;
        this.schema = schema;
        this.skipIfEmpty = skipIfEmpty;
    }

    public SerializedNameValuePair type(HttpPartType value) {
        this.type = value;
        return this;
    }

    public SerializedNameValuePair serializer(HttpPartSerializer value) {
        if (value != null) {
            return this.serializer(value.createPartSession(null));
        }
        return this;
    }

    public SerializedNameValuePair serializer(HttpPartSerializerSession value) {
        return this.serializer(value, true);
    }

    public SerializedNameValuePair serializer(HttpPartSerializerSession value, boolean overwrite) {
        if (overwrite || this.serializer == null) {
            this.serializer = value;
        }
        return this;
    }

    public SerializedNameValuePair schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public SerializedNameValuePair skipIfEmpty() {
        return this.skipIfEmpty(true);
    }

    public SerializedNameValuePair skipIfEmpty(boolean value) {
        this.skipIfEmpty = value;
        return this;
    }

    @Override
    public SerializedHeader asHeader() {
        return new SerializedHeader(this.getName(), this.value, this.serializer, this.schema, this.skipIfEmpty);
    }

    @Override
    public String getValue() {
        try {
            Object v = this.unwrap(this.value);
            HttpPartSchema schema = this.schema == null ? HttpPartSchema.DEFAULT : this.schema;
            String def = schema.getDefault();
            if (v == null) {
                if (def == null && !schema.isRequired()) {
                    return null;
                }
                if (def == null && schema.isAllowEmptyValue()) {
                    return null;
                }
            }
            if (StringUtils.isEmpty(v) && this.skipIfEmpty && def == null) {
                return null;
            }
            return this.serializer == null ? StringUtils.stringify(v) : this.serializer.serialize(this.type, schema, v);
        }
        catch (SchemaValidationException e) {
            throw new BasicRuntimeException(e, "Validation error on request {0} parameter ''{1}''=''{2}''", new Object[]{this.type, this.getName(), this.value});
        }
        catch (SerializeException e) {
            throw new BasicRuntimeException(e, "Serialization error on request {0} parameter ''{1}''", new Object[]{this.type, this.getName()});
        }
    }

    @Override
    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    private Object unwrap(Object o) {
        if (o instanceof Supplier) {
            return ((Supplier)o).get();
        }
        return o;
    }
}

