/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Collection;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(bpi="title,description,version,contact,license,termsOfService,*")
public class Info
extends SwaggerElement {
    private String title;
    private String description;
    private String termsOfService;
    private String version;
    private Contact contact;
    private License license;

    public Info() {
    }

    public Info(Info copyFrom) {
        super(copyFrom);
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.termsOfService = copyFrom.termsOfService;
        this.version = copyFrom.version;
        this.contact = copyFrom.contact == null ? null : copyFrom.contact.copy();
        this.license = copyFrom.license == null ? null : copyFrom.license.copy();
    }

    public Info copy() {
        return new Info(this);
    }

    public String getTitle() {
        return this.title;
    }

    public Info setTitle(String value) {
        this.title = value;
        return this;
    }

    public Info title(Object value) {
        return this.setTitle(StringUtils.stringify((Object)value));
    }

    public String getDescription() {
        return this.description;
    }

    public Info setDescription(String value) {
        this.description = value;
        return this;
    }

    public Info description(Object value) {
        return this.setDescription(StringUtils.stringify((Object)value));
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public Info setTermsOfService(String value) {
        this.termsOfService = value;
        return this;
    }

    public Info termsOfService(Object value) {
        return this.setTermsOfService(StringUtils.stringify((Object)value));
    }

    public Contact getContact() {
        return this.contact;
    }

    public Info setContact(Contact value) {
        this.contact = value;
        return this;
    }

    public Info contact(Object value) {
        return this.setContact((Contact)ConverterUtils.toType((Object)value, Contact.class));
    }

    public License getLicense() {
        return this.license;
    }

    public Info setLicense(License value) {
        this.license = value;
        return this;
    }

    public Info license(Object value) {
        return this.setLicense((License)ConverterUtils.toType((Object)value, License.class));
    }

    public String getVersion() {
        return this.version;
    }

    public Info setVersion(String value) {
        this.version = value;
        return this;
    }

    public Info version(Object value) {
        return this.setVersion(StringUtils.stringify((Object)value));
    }

    public boolean hasTitle() {
        return StringUtils.isNotEmpty((String)this.title);
    }

    public boolean hasDescription() {
        return StringUtils.isNotEmpty((String)this.description);
    }

    public boolean hasVersion() {
        return StringUtils.isNotEmpty((String)this.version);
    }

    public boolean hasTermsOfService() {
        return StringUtils.isNotEmpty((String)this.termsOfService);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "title": {
                return (T)ConverterUtils.toType((Object)this.getTitle(), type);
            }
            case "description": {
                return (T)ConverterUtils.toType((Object)this.getDescription(), type);
            }
            case "termsOfService": {
                return (T)ConverterUtils.toType((Object)this.getTermsOfService(), type);
            }
            case "contact": {
                return (T)ConverterUtils.toType((Object)this.getContact(), type);
            }
            case "license": {
                return (T)ConverterUtils.toType((Object)this.getLicense(), type);
            }
            case "version": {
                return (T)ConverterUtils.toType((Object)this.getVersion(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Info set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "title": {
                return this.title(value);
            }
            case "description": {
                return this.description(value);
            }
            case "termsOfService": {
                return this.termsOfService(value);
            }
            case "contact": {
                return this.contact(value);
            }
            case "license": {
                return this.license(value);
            }
            case "version": {
                return this.version(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet s = ASet.of((Object[])new String[0]).aif(this.title != null, (Object)"title").aif(this.description != null, (Object)"description").aif(this.termsOfService != null, (Object)"termsOfService").aif(this.contact != null, (Object)"contact").aif(this.license != null, (Object)"license").aif(this.version != null, (Object)"version");
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

