/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.AbstractScale;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0014J\b\u0010\u0018\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;", "", "name", "", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;)V", "b", "Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale$MyBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale$MyBuilder;)V", "isContinuous", "", "()Z", "isContinuousDomain", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "getTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "getBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "getBreaksIntern", "", "getLabelsIntern", "hasBreaks", "with", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "MyBuilder", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDiscreteScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscreteScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n766#2:99\n857#2,2:100\n766#2:103\n857#2,2:104\n1549#2:106\n1620#2,3:107\n1#3:102\n*S KotlinDebug\n*F\n+ 1 DiscreteScale.kt\norg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale\n*L\n52#1:99\n52#1:100,2\n72#1:103\n72#1:104,2\n73#1:106\n73#1:107,3\n*E\n"})
public final class DiscreteScale
extends AbstractScale<Object> {
    @NotNull
    private final DiscreteTransform discreteTransform;
    private final boolean isContinuous;
    private final boolean isContinuousDomain;

    @Override
    @NotNull
    public Transform getTransform() {
        return this.discreteTransform;
    }

    @Override
    public boolean isContinuous() {
        return this.isContinuous;
    }

    @Override
    public boolean isContinuousDomain() {
        return this.isContinuousDomain;
    }

    public DiscreteScale(@NotNull String name, @NotNull DiscreteTransform discreteTransform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        super(name, null);
        this.discreteTransform = discreteTransform;
        this.setMultiplicativeExpand(0.0);
        this.setAdditiveExpand(0.2);
    }

    private DiscreteScale(MyBuilder b2) {
        super(b2);
        this.discreteTransform = b2.getDiscreteTransform$plot_base();
    }

    @Override
    @NotNull
    public BreaksGenerator getBreaksGenerator() {
        throw new IllegalStateException("No breaks generator for discrete scale '" + this.getName() + '\'');
    }

    @Override
    public boolean hasBreaks() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Object> getBreaksIntern() {
        List list2;
        if (this.hasDefinedBreaks()) {
            void $this$filterTo$iv$iv;
            Set breaksSet = CollectionsKt.toSet((Iterable)super.getBreaksIntern());
            Iterable $this$filter$iv = this.discreteTransform.getEffectiveDomain();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!breaksSet.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = this.discreteTransform.getEffectiveDomain();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getLabelsIntern() {
        List list2;
        List labels = super.getLabelsIntern();
        if (!this.getTransform().hasDomainLimits() || labels.isEmpty()) {
            list2 = labels;
        } else if (!this.hasDefinedBreaks()) {
            list2 = labels;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection<String> collection;
            List breaks = super.getBreaksIntern();
            int n = breaks.size();
            Iterable<String> iterable = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                void i2;
                int n2;
                int n3 = n2 = i;
                collection = iterable;
                boolean bl = false;
                ((ArrayList)collection).add(i2 < labels.size() ? labels.get((int)i2) : "");
            }
            List breakLabels = iterable;
            Map labelByBreak = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)breaks, (Iterable)breakLabels));
            iterable = this.discreteTransform.getEffectiveDomain();
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!labelByBreak.containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)MapsKt.getValue((Map)labelByBreak, it));
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @Override
    @NotNull
    public Scale.Builder with() {
        return new MyBuilder(this);
    }

    public /* synthetic */ DiscreteScale(MyBuilder b2, DefaultConstructorMarker $constructor_marker) {
        this(b2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale$MyBuilder;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/DiscreteScale;)V", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "getDiscreteTransform$plot_base", "()Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "breaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "v", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "build", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "continuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "plot-base"})
    private static final class MyBuilder
    extends AbstractScale.AbstractBuilder<Object> {
        @NotNull
        private final DiscreteTransform discreteTransform;

        public MyBuilder(@NotNull DiscreteScale scale) {
            Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
            super(scale);
            this.discreteTransform = scale.discreteTransform;
        }

        @NotNull
        public final DiscreteTransform getDiscreteTransform$plot_base() {
            return this.discreteTransform;
        }

        @Override
        @NotNull
        public Scale.Builder breaksGenerator(@NotNull BreaksGenerator v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            throw new IllegalStateException("Not applicable to scale with discrete domain");
        }

        @Override
        @NotNull
        public Scale.Builder continuousTransform(@NotNull ContinuousTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this;
        }

        @Override
        @NotNull
        public Scale build() {
            return new DiscreteScale(this, null);
        }
    }
}

