/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ECSSAttributeOperator;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorAttribute
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sNamespacePrefix;
    private final String m_sAttrName;
    private final ECSSAttributeOperator m_eOperator;
    private final String m_sAttrValue;
    private CSSSourceLocation m_aSourceLocation;

    private static boolean _isValidNamespacePrefix(@Nullable String string) {
        return StringHelper.hasNoText((String)string) || string.endsWith("|");
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonnull @Nonempty String string2) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"AttrName");
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = null;
        this.m_sAttrValue = null;
    }

    public CSSSelectorAttribute(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull ECSSAttributeOperator eCSSAttributeOperator, @Nonnull String string3) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(string)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"AttrName");
        ValueEnforcer.notNull((Object)eCSSAttributeOperator, (String)"Operator");
        ValueEnforcer.notNull((Object)string3, (String)"AttrValue");
        this.m_sNamespacePrefix = string;
        this.m_sAttrName = string2;
        this.m_eOperator = eCSSAttributeOperator;
        this.m_sAttrValue = string3;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonnull
    @Nonempty
    public String getAttrName() {
        return this.m_sAttrName;
    }

    @Nullable
    public ECSSAttributeOperator getOperator() {
        return this.m_eOperator;
    }

    @Nullable
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (StringHelper.hasText((String)this.m_sNamespacePrefix)) {
            stringBuilder.append(this.m_sNamespacePrefix);
        }
        stringBuilder.append(this.m_sAttrName);
        if (this.m_eOperator != null) {
            stringBuilder.append(this.m_eOperator.getAsCSSString(iCSSWriterSettings, n)).append(this.m_sAttrValue);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorAttribute cSSSelectorAttribute = (CSSSelectorAttribute)object;
        return EqualsHelper.equals((Object)this.m_sNamespacePrefix, (Object)cSSSelectorAttribute.m_sNamespacePrefix) && this.m_sAttrName.equals(cSSSelectorAttribute.m_sAttrName) && EqualsHelper.equals((Object)this.m_eOperator, (Object)cSSSelectorAttribute.m_eOperator) && EqualsHelper.equals((Object)this.m_sAttrValue, (Object)cSSSelectorAttribute.m_sAttrValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sNamespacePrefix).append((Object)this.m_sAttrName).append((Enum)this.m_eOperator).append((Object)this.m_sAttrValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("namespacePrefix", (Object)this.m_sNamespacePrefix).append("attrName", (Object)this.m_sAttrName).appendIfNotNull("operator", (Object)this.m_eOperator).appendIfNotNull("attrValue", (Object)this.m_sAttrValue).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

