/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;

public enum LoggingLevel {
    DEBUG(logger -> logger::debug),
    ERROR(logger -> logger::error),
    INFO(logger -> logger::info),
    TRACE(logger -> logger::trace),
    WARNING(logger -> logger::warn);

    private final Function<Logger, BiConsumer<String, Object[]>> formatter;

    private LoggingLevel(Function<Logger, BiConsumer<String, Object[]>> formatter) {
        this.formatter = formatter;
    }

    public void format(Logger logger, String format, Object ... arguments) {
        this.formatter.apply(logger).accept(format, arguments);
    }
}

