/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSet;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Attribute
implements Serializable {
    @NotNull
    private static final ASN1OctetString[] NO_VALUES = new ASN1OctetString[0];
    @NotNull
    private static final byte[][] NO_BYTE_VALUES = new byte[0][];
    private static final long serialVersionUID = 5867076498293567612L;
    @NotNull
    private final ASN1OctetString[] values;
    private int hashCode = -1;
    @NotNull
    private final MatchingRule matchingRule;
    @NotNull
    private final String name;

    public Attribute(@NotNull String name) {
        Validator.ensureNotNull(name);
        this.name = name;
        this.values = NO_VALUES;
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, @NotNull String value) {
        Validator.ensureNotNull(name, value);
        this.name = name;
        this.values = new ASN1OctetString[]{new ASN1OctetString(value)};
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, @NotNull byte[] value) {
        Validator.ensureNotNull(name, value);
        this.name = name;
        this.values = new ASN1OctetString[]{new ASN1OctetString(value)};
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, String ... values) {
        Validator.ensureNotNull(name, values);
        this.name = name;
        this.values = new ASN1OctetString[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = new ASN1OctetString(values[i]);
        }
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, byte[] ... values) {
        Validator.ensureNotNull(name, values);
        this.name = name;
        this.values = new ASN1OctetString[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = new ASN1OctetString(values[i]);
        }
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, ASN1OctetString ... values) {
        Validator.ensureNotNull(name, values);
        this.name = name;
        this.values = values;
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, @NotNull Collection<String> values) {
        Validator.ensureNotNull(name, values);
        this.name = name;
        this.values = new ASN1OctetString[values.size()];
        int i = 0;
        for (String s : values) {
            this.values[i++] = new ASN1OctetString(s);
        }
        this.matchingRule = CaseIgnoreStringMatchingRule.getInstance();
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule) {
        Validator.ensureNotNull(name, matchingRule);
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = NO_VALUES;
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule, @NotNull String value) {
        Validator.ensureNotNull(name, matchingRule, value);
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[]{new ASN1OctetString(value)};
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule, @NotNull byte[] value) {
        Validator.ensureNotNull(name, matchingRule, value);
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[]{new ASN1OctetString(value)};
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule, String ... values) {
        Validator.ensureNotNull(name, matchingRule, values);
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = new ASN1OctetString(values[i]);
        }
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule, byte[] ... values) {
        Validator.ensureNotNull(name, matchingRule, values);
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = new ASN1OctetString(values[i]);
        }
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule, @NotNull Collection<String> values) {
        Validator.ensureNotNull(name, matchingRule, values);
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ASN1OctetString[values.size()];
        int i = 0;
        for (String s : values) {
            this.values[i++] = new ASN1OctetString(s);
        }
    }

    public Attribute(@NotNull String name, @NotNull MatchingRule matchingRule, @NotNull ASN1OctetString[] values) {
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = values;
    }

    public Attribute(@NotNull String name, @Nullable Schema schema, String ... values) {
        this(name, MatchingRule.selectEqualityMatchingRule(name, schema), values);
    }

    public Attribute(@NotNull String name, @Nullable Schema schema, byte[] ... values) {
        this(name, MatchingRule.selectEqualityMatchingRule(name, schema), values);
    }

    public Attribute(@NotNull String name, @Nullable Schema schema, @NotNull Collection<String> values) {
        this(name, MatchingRule.selectEqualityMatchingRule(name, schema), values);
    }

    public Attribute(@NotNull String name, @Nullable Schema schema, @NotNull ASN1OctetString[] values) {
        this(name, MatchingRule.selectEqualityMatchingRule(name, schema), values);
    }

    @NotNull
    public static Attribute mergeAttributes(@NotNull Attribute attr1, @NotNull Attribute attr2) {
        return Attribute.mergeAttributes(attr1, attr2, attr1.matchingRule);
    }

    @NotNull
    public static Attribute mergeAttributes(@NotNull Attribute attr1, @NotNull Attribute attr2, @Nullable MatchingRule matchingRule) {
        Validator.ensureNotNull(attr1, attr2);
        String name = attr1.name;
        Validator.ensureTrue(name.equalsIgnoreCase(attr2.name));
        MatchingRule mr = matchingRule == null ? attr1.matchingRule : matchingRule;
        ASN1OctetString[] mergedValues = new ASN1OctetString[attr1.values.length + attr2.values.length];
        System.arraycopy(attr1.values, 0, mergedValues, 0, attr1.values.length);
        int pos = attr1.values.length;
        for (ASN1OctetString attr2Value : attr2.values) {
            if (attr1.hasValue(attr2Value, mr)) continue;
            mergedValues[pos++] = attr2Value;
        }
        if (pos != mergedValues.length) {
            ASN1OctetString[] newMergedValues = new ASN1OctetString[pos];
            System.arraycopy(mergedValues, 0, newMergedValues, 0, pos);
            mergedValues = newMergedValues;
        }
        return new Attribute(name, mr, mergedValues);
    }

    @NotNull
    public static Attribute removeValues(@NotNull Attribute attr1, @NotNull Attribute attr2) {
        return Attribute.removeValues(attr1, attr2, attr1.matchingRule);
    }

    @NotNull
    public static Attribute removeValues(@NotNull Attribute attr1, @NotNull Attribute attr2, @Nullable MatchingRule matchingRule) {
        Validator.ensureNotNull(attr1, attr2);
        String name = attr1.name;
        Validator.ensureTrue(name.equalsIgnoreCase(attr2.name));
        MatchingRule mr = matchingRule == null ? attr1.matchingRule : matchingRule;
        ArrayList<ASN1OctetString> newValues = new ArrayList<ASN1OctetString>(Arrays.asList(attr1.values));
        Iterator<ASN1OctetString> iterator = newValues.iterator();
        while (iterator.hasNext()) {
            if (!attr2.hasValue(iterator.next(), mr)) continue;
            iterator.remove();
        }
        ASN1OctetString[] newValueArray = new ASN1OctetString[newValues.size()];
        newValues.toArray(newValueArray);
        return new Attribute(name, mr, newValueArray);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getBaseName() {
        return Attribute.getBaseName(this.name);
    }

    @NotNull
    public static String getBaseName(@NotNull String name) {
        int semicolonPos = name.indexOf(59);
        if (semicolonPos > 0) {
            return name.substring(0, semicolonPos);
        }
        return name;
    }

    public boolean nameIsValid() {
        return Attribute.nameIsValid(this.name, true);
    }

    public static boolean nameIsValid(@NotNull String s) {
        return Attribute.nameIsValid(s, true);
    }

    public static boolean nameIsValid(@NotNull String s, boolean allowOptions) {
        int length;
        if (s == null || (length = s.length()) == 0) {
            return false;
        }
        char firstChar = s.charAt(0);
        if (!(firstChar >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z')) {
            return false;
        }
        boolean lastWasSemiColon = false;
        for (int i = 1; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                lastWasSemiColon = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '-') {
                if (lastWasSemiColon) {
                    return false;
                }
                lastWasSemiColon = false;
                continue;
            }
            if (c == ';') {
                if (lastWasSemiColon || !allowOptions) {
                    return false;
                }
                lastWasSemiColon = true;
                continue;
            }
            return false;
        }
        return !lastWasSemiColon;
    }

    public boolean hasOptions() {
        return Attribute.hasOptions(this.name);
    }

    public static boolean hasOptions(@NotNull String name) {
        return name.indexOf(59) > 0;
    }

    public boolean hasOption(@NotNull String option) {
        return Attribute.hasOption(this.name, option);
    }

    public static boolean hasOption(@NotNull String name, @NotNull String option) {
        Set<String> options = Attribute.getOptions(name);
        for (String s : options) {
            if (!s.equalsIgnoreCase(option)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> getOptions() {
        return Attribute.getOptions(this.name);
    }

    @NotNull
    public static Set<String> getOptions(@NotNull String name) {
        int semicolonPos = name.indexOf(59);
        if (semicolonPos > 0) {
            int nextSemicolonPos;
            LinkedHashSet<String> options = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(5));
            while ((nextSemicolonPos = name.indexOf(59, semicolonPos + 1)) > 0) {
                options.add(name.substring(semicolonPos + 1, nextSemicolonPos));
                semicolonPos = nextSemicolonPos;
            }
            options.add(name.substring(semicolonPos + 1));
            return Collections.unmodifiableSet(options);
        }
        return Collections.emptySet();
    }

    @NotNull
    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    @Nullable
    public String getValue() {
        if (this.values.length == 0) {
            return null;
        }
        return this.values[0].stringValue();
    }

    @Nullable
    public byte[] getValueByteArray() {
        if (this.values.length == 0) {
            return null;
        }
        return this.values[0].getValue();
    }

    @Nullable
    public Boolean getValueAsBoolean() {
        if (this.values.length == 0) {
            return null;
        }
        String lowerValue = StaticUtils.toLowerCase(this.values[0].stringValue());
        if (lowerValue.equals("true") || lowerValue.equals("t") || lowerValue.equals("yes") || lowerValue.equals("y") || lowerValue.equals("on") || lowerValue.equals("1")) {
            return Boolean.TRUE;
        }
        if (lowerValue.equals("false") || lowerValue.equals("f") || lowerValue.equals("no") || lowerValue.equals("n") || lowerValue.equals("off") || lowerValue.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Nullable
    public Date getValueAsDate() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime(this.values[0].stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public DN getValueAsDN() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return new DN(this.values[0].stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    public Integer getValueAsInteger() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return Integer.valueOf(this.values[0].stringValue());
        }
        catch (NumberFormatException nfe) {
            Debug.debugException(nfe);
            return null;
        }
    }

    @Nullable
    public Long getValueAsLong() {
        if (this.values.length == 0) {
            return null;
        }
        try {
            return Long.valueOf(this.values[0].stringValue());
        }
        catch (NumberFormatException nfe) {
            Debug.debugException(nfe);
            return null;
        }
    }

    @NotNull
    public String[] getValues() {
        if (this.values.length == 0) {
            return StaticUtils.NO_STRINGS;
        }
        String[] stringValues = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringValues[i] = this.values[i].stringValue();
        }
        return stringValues;
    }

    @NotNull
    public byte[][] getValueByteArrays() {
        if (this.values.length == 0) {
            return NO_BYTE_VALUES;
        }
        byte[][] byteValues = new byte[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            byteValues[i] = this.values[i].getValue();
        }
        return byteValues;
    }

    @NotNull
    public ASN1OctetString[] getRawValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.values.length > 0;
    }

    public boolean hasValue(@NotNull String value) {
        Validator.ensureNotNull(value);
        return this.hasValue(new ASN1OctetString(value), this.matchingRule);
    }

    public boolean hasValue(@NotNull String value, @NotNull MatchingRule matchingRule) {
        Validator.ensureNotNull(value);
        return this.hasValue(new ASN1OctetString(value), matchingRule);
    }

    public boolean hasValue(@NotNull byte[] value) {
        Validator.ensureNotNull(value);
        return this.hasValue(new ASN1OctetString(value), this.matchingRule);
    }

    public boolean hasValue(@NotNull byte[] value, @NotNull MatchingRule matchingRule) {
        Validator.ensureNotNull(value);
        return this.hasValue(new ASN1OctetString(value), matchingRule);
    }

    boolean hasValue(@NotNull ASN1OctetString value) {
        return this.hasValue(value, this.matchingRule);
    }

    boolean hasValue(@NotNull ASN1OctetString value, @NotNull MatchingRule matchingRule) {
        try {
            return matchingRule.matchesAnyValue(value, this.values);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            for (ASN1OctetString existingValue : this.values) {
                if (!value.equalsIgnoreType(existingValue)) continue;
                return true;
            }
            return false;
        }
    }

    public int size() {
        return this.values.length;
    }

    public void writeTo(@NotNull ASN1Buffer buffer) {
        ASN1BufferSequence attrSequence = buffer.beginSequence();
        buffer.addOctetString(this.name);
        ASN1BufferSet valueSet = buffer.beginSet();
        for (ASN1OctetString value : this.values) {
            buffer.addElement(value);
        }
        valueSet.end();
        attrSequence.end();
    }

    @NotNull
    public ASN1Sequence encode() {
        ASN1Element[] elements = new ASN1Element[]{new ASN1OctetString(this.name), new ASN1Set(this.values)};
        return new ASN1Sequence(elements);
    }

    @NotNull
    public static Attribute readFrom(@NotNull ASN1StreamReader reader) throws LDAPException {
        return Attribute.readFrom(reader, null);
    }

    @NotNull
    public static Attribute readFrom(@NotNull ASN1StreamReader reader, @Nullable Schema schema) throws LDAPException {
        try {
            Validator.ensureNotNull(reader.beginSequence());
            String attrName = reader.readString();
            Validator.ensureNotNull(attrName);
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(attrName, schema);
            ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(10);
            ASN1StreamReaderSet valueSet = reader.beginSet();
            while (valueSet.hasMoreElements()) {
                valueList.add(new ASN1OctetString(reader.readBytes()));
            }
            ASN1OctetString[] values = new ASN1OctetString[valueList.size()];
            valueList.toArray(values);
            return new Attribute(attrName, matchingRule, values);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_ATTR_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static Attribute decode(@NotNull ASN1Sequence encodedAttribute) throws LDAPException {
        ASN1Set valueSet;
        Validator.ensureNotNull(encodedAttribute);
        ASN1Element[] elements = encodedAttribute.elements();
        if (elements.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_ATTR_DECODE_INVALID_COUNT.get(elements.length));
        }
        String name = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        try {
            valueSet = ASN1Set.decodeAsSet(elements[1]);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_ATTR_DECODE_VALUE_SET.get(StaticUtils.getExceptionMessage(ae)), ae);
        }
        ASN1OctetString[] values = new ASN1OctetString[valueSet.elements().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ASN1OctetString.decodeAsOctetString(valueSet.elements()[i]);
        }
        return new Attribute(name, (MatchingRule)CaseIgnoreStringMatchingRule.getInstance(), values);
    }

    public boolean needsBase64Encoding() {
        for (ASN1OctetString v : this.values) {
            if (!Attribute.needsBase64Encoding(v.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean needsBase64Encoding(@NotNull String v) {
        return Attribute.needsBase64Encoding(StaticUtils.getBytes(v));
    }

    public static boolean needsBase64Encoding(@NotNull byte[] v) {
        return LDIFWriter.getBase64EncodingStrategy().shouldBase64Encode(v);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int c = StaticUtils.toLowerCase(this.name).hashCode();
            for (ASN1OctetString value : this.values) {
                try {
                    c += this.matchingRule.normalize(value).hashCode();
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    c += value.hashCode();
                }
            }
            this.hashCode = c;
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object o) {
        block14: {
            Attribute a;
            block13: {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Attribute)) {
                    return false;
                }
                a = (Attribute)o;
                if (!this.name.equalsIgnoreCase(a.name)) {
                    return false;
                }
                if (this.values.length != a.values.length) {
                    return false;
                }
                if (this.values.length <= 10) break block13;
                HashSet<ASN1OctetString> unNormalizedValues = StaticUtils.hashSetOf(this.values);
                HashSet<ASN1OctetString> normalizedMissingValues = null;
                for (ASN1OctetString value : a.values) {
                    if (unNormalizedValues.remove(value)) continue;
                    if (normalizedMissingValues == null) {
                        normalizedMissingValues = new HashSet<ASN1OctetString>(StaticUtils.computeMapCapacity(this.values.length));
                    }
                    try {
                        normalizedMissingValues.add(this.matchingRule.normalize(value));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        return false;
                    }
                }
                if (normalizedMissingValues == null) break block14;
                for (ASN1OctetString value : unNormalizedValues) {
                    try {
                        if (normalizedMissingValues.contains(this.matchingRule.normalize(value))) continue;
                        return false;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        return false;
                    }
                }
                break block14;
            }
            for (ASN1OctetString value : this.values) {
                if (a.hasValue(value)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("Attribute(name=");
        buffer.append(this.name);
        if (this.values.length == 0) {
            buffer.append(", values={");
        } else if (this.needsBase64Encoding()) {
            buffer.append(", base64Values={'");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    buffer.append("', '");
                }
                buffer.append(Base64.encode(this.values[i].getValue()));
            }
            buffer.append('\'');
        } else {
            buffer.append(", values={'");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    buffer.append("', '");
                }
                buffer.append(this.values[i].stringValue());
            }
            buffer.append('\'');
        }
        buffer.append("})");
    }
}

