/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.json.MailboxACLJsonConverter;
import org.apache.james.mailbox.cassandra.table.CassandraACLTable;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.util.FunctionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraACLDAOV1 {
    public static final int INITIAL_VALUE = 0;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraACLDAOV1.class);
    private static final String OLD_VERSION = "oldVersion";
    private final CassandraAsyncExecutor executor;
    private final int maxAclRetry;
    private final PreparedStatement conditionalInsertStatement;
    private final PreparedStatement conditionalUpdateStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement deleteStatement;
    private final CqlSession session;
    private final DriverExecutionProfile lwtProfile;

    @Inject
    public CassandraACLDAOV1(CqlSession session, CassandraConfiguration cassandraConfiguration) {
        this.session = session;
        this.executor = new CassandraAsyncExecutor(session);
        this.maxAclRetry = cassandraConfiguration.getAclMaxRetry();
        this.conditionalInsertStatement = this.prepareConditionalInsert();
        this.conditionalUpdateStatement = this.prepareConditionalUpdate();
        this.readStatement = this.prepareReadStatement();
        this.deleteStatement = this.prepareDelete();
        this.lwtProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
    }

    private PreparedStatement prepareDelete() {
        return this.session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"acl").where((Relation)Relation.column((CqlIdentifier)CassandraACLTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.ID)))).ifExists()).build());
    }

    private PreparedStatement prepareConditionalInsert() {
        return this.session.prepare(QueryBuilder.insertInto((String)"acl").value(CassandraACLTable.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.ID)).value(CassandraACLTable.ACL, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.ACL)).value(CassandraACLTable.VERSION, (Term)QueryBuilder.literal((Object)0)).ifNotExists().build());
    }

    private PreparedStatement prepareConditionalUpdate() {
        return this.session.prepare(((Update)((Update)QueryBuilder.update((String)"acl").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)CassandraACLTable.ACL, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.ACL)), Assignment.setColumn((CqlIdentifier)CassandraACLTable.VERSION, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.VERSION))}).where((Relation)Relation.column((CqlIdentifier)CassandraACLTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.ID)))).ifColumn(CassandraACLTable.VERSION).isEqualTo((Term)QueryBuilder.bindMarker((String)OLD_VERSION))).build());
    }

    private PreparedStatement prepareReadStatement() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"acl").columns(new CqlIdentifier[]{CassandraACLTable.ACL, CassandraACLTable.VERSION}).where((Relation)Relation.column((CqlIdentifier)CassandraACLTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLTable.ID)))).build());
    }

    public Mono<MailboxACL> getACL(CassandraId cassandraId) {
        return this.getStoredACLRow(cassandraId).map(row -> this.getAcl(cassandraId, (Row)row));
    }

    private MailboxACL getAcl(CassandraId cassandraId, Row row) {
        String serializedACL = row.getString(CassandraACLTable.ACL);
        return this.deserializeACL(cassandraId, serializedACL);
    }

    public Mono<ACLDiff> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
        return Mono.fromCallable(() -> MailboxACL.EMPTY.apply(command)).flatMap(replacement -> this.doUpdateAcl(cassandraId, aclWithVersion -> aclWithVersion.apply(command), (MailboxACL)replacement));
    }

    public Mono<ACLDiff> setACL(CassandraId cassandraId, MailboxACL mailboxACL) {
        return this.doUpdateAcl(cassandraId, acl -> new ACLWithVersion(acl.version, mailboxACL), mailboxACL);
    }

    Mono<ACLDiff> doUpdateAcl(CassandraId cassandraId, Function<ACLWithVersion, ACLWithVersion> aclTransformation, MailboxACL replacement) {
        return this.getAclWithVersion(cassandraId).flatMap(aclWithVersion -> this.updateStoredACL(cassandraId, (ACLWithVersion)aclTransformation.apply((ACLWithVersion)aclWithVersion)).map(newACL -> ACLDiff.computeDiff((MailboxACL)aclWithVersion.mailboxACL, (MailboxACL)newACL))).switchIfEmpty(this.insertACL(cassandraId, replacement).map(newACL -> ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)newACL))).single().retry((long)this.maxAclRetry);
    }

    private Mono<Row> getStoredACLRow(CassandraId cassandraId) {
        return this.executor.executeSingleRow(((BoundStatement)this.readStatement.bind(new Object[0]).setUuid(CassandraACLTable.ID, cassandraId.asUuid())).setExecutionProfile(this.lwtProfile));
    }

    private Mono<MailboxACL> updateStoredACL(CassandraId cassandraId, ACLWithVersion aclWithVersion) {
        return this.executor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.conditionalUpdateStatement.bind(new Object[0]).setUuid(CassandraACLTable.ID, cassandraId.asUuid())).setString(CassandraACLTable.ACL, this.convertAclToJson(aclWithVersion.mailboxACL))).setLong(CassandraACLTable.VERSION, aclWithVersion.version + 1L)).setLong(OLD_VERSION, aclWithVersion.version)).filter(FunctionalUtils.identityPredicate()).map(any -> aclWithVersion.mailboxACL);
    }

    public Mono<Void> delete(CassandraId cassandraId) {
        return this.executor.executeVoid((Statement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraACLTable.ID, cassandraId.asUuid()));
    }

    private Mono<MailboxACL> insertACL(CassandraId cassandraId, MailboxACL acl) {
        return this.executor.executeReturnApplied((Statement)((BoundStatement)this.conditionalInsertStatement.bind(new Object[0]).setUuid(CassandraACLTable.ID, cassandraId.asUuid())).setString(CassandraACLTable.ACL, this.convertAclToJson(acl))).filter(FunctionalUtils.identityPredicate()).map(any -> acl);
    }

    private String convertAclToJson(MailboxACL acl) {
        try {
            return MailboxACLJsonConverter.toJson(acl);
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Mono<ACLWithVersion> getAclWithVersion(CassandraId cassandraId) {
        return this.getStoredACLRow(cassandraId).map(acl -> new ACLWithVersion(acl.getLong(CassandraACLTable.VERSION), this.deserializeACL(cassandraId, acl.getString(CassandraACLTable.ACL))));
    }

    private MailboxACL deserializeACL(CassandraId cassandraId, String serializedACL) {
        try {
            return MailboxACLJsonConverter.toACL(serializedACL);
        }
        catch (IOException exception) {
            LOG.error("Unable to read stored ACL. We will use empty ACL instead.Mailbox is {} .ACL is {}", new Object[]{cassandraId, serializedACL, exception});
            return MailboxACL.EMPTY;
        }
    }

    private static class ACLWithVersion {
        private final long version;
        private final MailboxACL mailboxACL;

        public ACLWithVersion(long version, MailboxACL mailboxACL) {
            this.version = version;
            this.mailboxACL = mailboxACL;
        }

        public ACLWithVersion apply(MailboxACL.ACLCommand command) {
            try {
                return new ACLWithVersion(this.version, this.mailboxACL.apply(command));
            }
            catch (UnsupportedRightException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

