/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailetcontainer.AutomaticallySentMailDetectorImpl;
import org.apache.james.mailetcontainer.api.LocalResources;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.mailetcontainer.api.MatcherLoader;
import org.apache.james.mailetcontainer.api.jmx.MailSpoolerMBean;
import org.apache.james.mailetcontainer.impl.CompositeProcessorImpl;
import org.apache.james.mailetcontainer.impl.JamesMailSpooler;
import org.apache.james.mailetcontainer.impl.JamesMailetContext;
import org.apache.james.mailetcontainer.impl.LocalResourcesImpl;
import org.apache.james.mailetcontainer.impl.MailetProcessorImpl;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.transport.mailets.RemoveMimeHeader;
import org.apache.james.transport.matchers.All;
import org.apache.james.utils.GuiceMailetLoader;
import org.apache.james.utils.GuiceMatcherLoader;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.MailetConfigurationOverride;
import org.apache.james.utils.SpoolerProbe;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetContext;
import org.apache.mailet.Matcher;
import org.apache.mailet.base.AutomaticallySentMailDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailetContainerModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailetContainerModule.class);
    public static final ProcessorsCheck.Impl BCC_Check = new ProcessorsCheck.Impl("transport", All.class, RemoveMimeHeader.class, pair -> pair.getMailet().getMailetConfig().getInitParameter("name").equals("bcc"), "Should be configured to remove Bcc header");

    protected void configure() {
        this.bind(CompositeProcessorImpl.class).in(Scopes.SINGLETON);
        this.bind(MailProcessor.class).to(CompositeProcessorImpl.class);
        this.bind(JamesMailSpooler.class).in(Scopes.SINGLETON);
        this.bind(MailSpoolerMBean.class).to(JamesMailSpooler.class);
        this.bind(JamesMailetContext.class).in(Scopes.SINGLETON);
        this.bind(MailetContext.class).to(JamesMailetContext.class);
        this.bind(LocalResourcesImpl.class).in(Scopes.SINGLETON);
        this.bind(LocalResources.class).to(LocalResourcesImpl.class);
        this.bind(AutomaticallySentMailDetectorImpl.class).in(Scopes.SINGLETON);
        this.bind(AutomaticallySentMailDetector.class).to(AutomaticallySentMailDetectorImpl.class);
        this.bind(MailetLoader.class).to(GuiceMailetLoader.class);
        this.bind(MatcherLoader.class).to(GuiceMatcherLoader.class);
        Multibinder.newSetBinder((Binder)this.binder(), MailetConfigurationOverride.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(SpoolerProbe.class);
        Multibinder initialisationOperations = Multibinder.newSetBinder((Binder)this.binder(), InitializationOperation.class);
        initialisationOperations.addBinding().to(MailetModuleInitializationOperation.class);
        Multibinder transportProcessorChecks = Multibinder.newSetBinder((Binder)this.binder(), ProcessorsCheck.class);
        transportProcessorChecks.addBinding().toInstance((Object)BCC_Check);
    }

    @Provides
    @Singleton
    public JamesMailSpooler.Configuration spoolerConfiguration(MailRepositoryStore mailRepositoryStore, ConfigurationProvider configurationProvider) {
        HierarchicalConfiguration<ImmutableNode> conf = this.getJamesSpoolerConfiguration(configurationProvider);
        return JamesMailSpooler.Configuration.from((MailRepositoryStore)mailRepositoryStore, conf);
    }

    private HierarchicalConfiguration<ImmutableNode> getJamesSpoolerConfiguration(ConfigurationProvider configurationProvider) {
        try {
            return configurationProvider.getConfiguration("mailetcontainer").configurationAt("spooler");
        }
        catch (Exception e) {
            LOGGER.warn("Could not locate configuration for James Spooler. Assuming empty configuration for this component.");
            return new BaseHierarchicalConfiguration();
        }
    }

    @ProvidesIntoSet
    InitializationOperation initMailetContext(ConfigurationProvider configurationProvider, JamesMailetContext mailetContext) {
        return InitilizationOperationBuilder.forClass(JamesMailetContext.class).init(() -> mailetContext.configure(this.getMailetContextConfiguration(configurationProvider)));
    }

    @VisibleForTesting
    HierarchicalConfiguration<ImmutableNode> getMailetContextConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        HierarchicalConfiguration mailetContainerConfiguration = configurationProvider.getConfiguration("mailetcontainer");
        try {
            return mailetContainerConfiguration.configurationAt("context");
        }
        catch (ConfigurationRuntimeException e) {
            LOGGER.warn("Could not locate configuration for Mailet context. Assuming empty configuration for this component.");
            return new BaseHierarchicalConfiguration();
        }
    }

    public static interface DefaultProcessorsConfigurationSupplier {
        public HierarchicalConfiguration<ImmutableNode> getDefaultConfiguration();
    }

    @FunctionalInterface
    public static interface ProcessorsCheck {
        public static ProcessorsCheck noCheck() {
            return new ProcessorsCheck(){

                @Override
                public void check(Multimap<String, MatcherMailetPair> processors) {
                }
            };
        }

        public void check(Multimap<String, MatcherMailetPair> var1) throws ConfigurationException;

        public static class Impl
        implements ProcessorsCheck {
            private final String processorName;
            private final Class<? extends Matcher> matcherClass;
            private final Class<? extends Mailet> mailetClass;
            private final Optional<Predicate<? super MatcherMailetPair>> additionalFilter;
            private final Optional<String> additionalErrorMessage;

            public Impl(String processorName, Class<? extends Matcher> matcherClass, Class<? extends Mailet> mailetClass) {
                this(processorName, matcherClass, mailetClass, Optional.empty(), Optional.empty());
            }

            public Impl(String processorName, Class<? extends Matcher> matcherClass, Class<? extends Mailet> mailetClass, Predicate<? super MatcherMailetPair> additionalFilter, String additionalErrorMessage) {
                this(processorName, matcherClass, mailetClass, Optional.of(additionalFilter), Optional.of(additionalErrorMessage));
            }

            private Impl(String processorName, Class<? extends Matcher> matcherClass, Class<? extends Mailet> mailetClass, Optional<Predicate<? super MatcherMailetPair>> additionalFilter, Optional<String> additionalErrorMessage) {
                this.processorName = processorName;
                this.matcherClass = matcherClass;
                this.mailetClass = mailetClass;
                this.additionalFilter = additionalFilter;
                this.additionalErrorMessage = additionalErrorMessage;
            }

            @Override
            public void check(Multimap<String, MatcherMailetPair> processors) throws ConfigurationException {
                Collection pairs = processors.get((Object)this.processorName);
                if (pairs == null) {
                    throw new ConfigurationException(this.processorName + " is missing");
                }
                Preconditions.checkNotNull((Object)pairs);
                pairs.stream().filter(pair -> pair.getMailet().getClass().equals(this.mailetClass)).filter(pair -> pair.getMatcher().getClass().equals(this.matcherClass)).filter(this.additionalFilter.orElse(any -> true)).findAny().orElseThrow(() -> new ConfigurationException("Missing " + this.mailetClass.getName() + " in mailets configuration (mailetcontainer -> processors -> " + this.processorName + "). " + this.additionalErrorMessage.orElse("")));
            }
        }

        public static class Or
        implements ProcessorsCheck {
            private final Set<ProcessorsCheck> checks;

            public static ProcessorsCheck of(ProcessorsCheck ... checks) {
                return new Or((Set<ProcessorsCheck>)ImmutableSet.copyOf((Object[])checks));
            }

            public Or(Set<ProcessorsCheck> checks) {
                Preconditions.checkArgument((!checks.isEmpty() ? 1 : 0) != 0);
                this.checks = checks;
            }

            @Override
            public void check(Multimap<String, MatcherMailetPair> processors) throws ConfigurationException {
                ImmutableList failures = (ImmutableList)this.checks.stream().flatMap(check -> {
                    try {
                        check.check(processors);
                        return Stream.empty();
                    }
                    catch (ConfigurationException e) {
                        return Stream.of(e);
                    }
                }).collect(ImmutableList.toImmutableList());
                if (failures.size() == this.checks.size()) {
                    throw (ConfigurationException)((Object)failures.get(0));
                }
            }
        }
    }

    @Singleton
    public static class MailetModuleInitializationOperation
    implements InitializationOperation {
        private final ConfigurationProvider configurationProvider;
        private final CompositeProcessorImpl compositeProcessorImpl;
        private final DefaultProcessorsConfigurationSupplier defaultProcessorsConfigurationSupplier;
        private final Set<ProcessorsCheck> processorsCheckSet;
        private final JamesMailSpooler jamesMailSpooler;
        private final JamesMailSpooler.Configuration spoolerConfiguration;

        @Inject
        public MailetModuleInitializationOperation(ConfigurationProvider configurationProvider, CompositeProcessorImpl compositeProcessorImpl, Set<ProcessorsCheck> processorsCheckSet, DefaultProcessorsConfigurationSupplier defaultProcessorsConfigurationSupplier, JamesMailSpooler jamesMailSpooler, JamesMailSpooler.Configuration spoolerConfiguration) {
            this.configurationProvider = configurationProvider;
            this.compositeProcessorImpl = compositeProcessorImpl;
            this.processorsCheckSet = processorsCheckSet;
            this.defaultProcessorsConfigurationSupplier = defaultProcessorsConfigurationSupplier;
            this.jamesMailSpooler = jamesMailSpooler;
            this.spoolerConfiguration = spoolerConfiguration;
        }

        public void initModule() throws Exception {
            this.configureProcessors();
            this.checkProcessors();
        }

        private void configureProcessors() throws Exception {
            this.compositeProcessorImpl.configure(this.getProcessorConfiguration());
            this.compositeProcessorImpl.init();
            this.jamesMailSpooler.configure(this.spoolerConfiguration);
            this.jamesMailSpooler.init();
        }

        @VisibleForTesting
        HierarchicalConfiguration<ImmutableNode> getProcessorConfiguration() throws ConfigurationException {
            HierarchicalConfiguration mailetContainerConfiguration = this.configurationProvider.getConfiguration("mailetcontainer");
            try {
                return mailetContainerConfiguration.configurationAt("processors");
            }
            catch (ConfigurationRuntimeException e) {
                LOGGER.warn("Could not load configuration for Processors. Fallback to default.");
                return this.defaultProcessorsConfigurationSupplier.getDefaultConfiguration();
            }
        }

        private void checkProcessors() throws ConfigurationException {
            ImmutableListMultimap processors = (ImmutableListMultimap)Arrays.stream(this.compositeProcessorImpl.getProcessorStates()).flatMap(state -> {
                MailProcessor processor = this.compositeProcessorImpl.getProcessor(state);
                if (processor instanceof MailetProcessorImpl) {
                    MailetProcessorImpl camelProcessor = (MailetProcessorImpl)processor;
                    return camelProcessor.getPairs().stream().map(pair -> Pair.of((Object)state, (Object)pair));
                }
                throw new RuntimeException("Can not perform checks as transport processor is not an instance of " + MailProcessor.class);
            }).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getKey, Pair::getValue));
            for (ProcessorsCheck check : this.processorsCheckSet) {
                check.check((Multimap<String, MatcherMailetPair>)processors);
            }
        }

        public Class<? extends Startable> forClass() {
            return CompositeProcessorImpl.class;
        }
    }
}

