/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.DeleteResult;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageMovesWithMailbox;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.ResultUtils;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.mail.FetchGroupConverter;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.FlagsFilter;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.quota.QuotaChecker;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StoreMessageIdManager
implements MessageIdManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreMessageIdManager.class);
    private final RightManager rightManager;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final EventBus eventBus;
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final PreDeletionHooks preDeletionHooks;

    public static ImmutableSet<MailboxId> toMailboxIds(List<MailboxMessage> mailboxMessages) {
        return (ImmutableSet)mailboxMessages.stream().map(MailboxMessage::getMailboxId).collect(ImmutableSet.toImmutableSet());
    }

    @Inject
    public StoreMessageIdManager(RightManager rightManager, MailboxSessionMapperFactory mailboxSessionMapperFactory, EventBus eventBus, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, PreDeletionHooks preDeletionHooks) {
        this.rightManager = rightManager;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.eventBus = eventBus;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.preDeletionHooks = preDeletionHooks;
    }

    public void setFlags(Flags newState, MessageManager.FlagsUpdateMode replace, MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MailboxReactorUtils.block(this.setFlagsReactive(newState, replace, messageId, mailboxIds, mailboxSession));
    }

    public Mono<Void> setFlagsReactive(Flags newState, MessageManager.FlagsUpdateMode replace, MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        int concurrency = 4;
        return Flux.fromIterable(mailboxIds).flatMap(mailboxMapper::findMailboxById, concurrency).collect(ImmutableList.toImmutableList()).flatMap(Throwing.function(targetMailboxes -> {
            this.assertRightsOnMailboxes((Collection<Mailbox>)targetMailboxes, mailboxSession, MailboxACL.Right.Write);
            return messageIdMapper.setFlags(messageId, mailboxIds, newState, replace).flatMapIterable(updatedFlags -> updatedFlags.asMap().entrySet()).concatMap(entry -> this.dispatchFlagsChange(mailboxSession, (MailboxId)entry.getKey(), (ImmutableList<UpdatedFlags>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())), (List<Mailbox>)targetMailboxes)).then();
        }).sneakyThrow());
    }

    public Set<MessageId> accessibleMessages(Collection<MessageId> messageIds, MailboxSession mailboxSession) {
        return (Set)this.accessibleMessagesReactive(messageIds, mailboxSession).block();
    }

    public Mono<Set<MessageId>> accessibleMessagesReactive(Collection<MessageId> messageIds, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return Flux.fromIterable(messageIds).flatMap(messageIdMapper::findMetadata, 16).collect(ImmutableList.toImmutableList()).flatMap(idList -> this.getAllowedMailboxIds(mailboxSession, idList.stream().map(id -> id.getComposedMessageId().getMailboxId()), MailboxACL.Right.Read).map(allowedMailboxIds -> (ImmutableSet)idList.stream().filter(id -> allowedMailboxIds.contains((Object)id.getComposedMessageId().getMailboxId())).map(id -> id.getComposedMessageId().getMessageId()).collect(ImmutableSet.toImmutableSet())));
    }

    public List<MessageResult> getMessages(Collection<MessageId> messageIds, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        return (List)this.getMessagesReactive(messageIds, fetchGroup, mailboxSession).collectList().block();
    }

    public Flux<MessageResult> getMessagesReactive(Collection<MessageId> messageIds, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        MessageMapper.FetchType fetchType = FetchGroupConverter.getFetchType(fetchGroup);
        return messageIdMapper.findReactive(messageIds, fetchType).groupBy(MailboxMessage::getMailboxId).filterWhen(groupedFlux -> (Publisher)this.hasRightsOnMailboxReactive(mailboxSession, MailboxACL.Right.Read).apply((MailboxId)groupedFlux.key()), 16).flatMap(Function.identity(), 16).map(Throwing.function(this.messageResultConverter(fetchGroup)).sneakyThrow());
    }

    public Publisher<ComposedMessageIdWithMetaData> messagesMetadata(Collection<MessageId> ids, MailboxSession session) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(session);
        int concurrency = 4;
        return Flux.fromIterable(ids).flatMap(messageIdMapper::findMetadata, concurrency).groupBy(metaData -> metaData.getComposedMessageId().getMailboxId()).filterWhen(groupedFlux -> (Publisher)this.hasRightsOnMailboxReactive(session, MailboxACL.Right.Read).apply((MailboxId)groupedFlux.key()), 16).flatMap(Function.identity(), 16);
    }

    private Mono<ImmutableSet<MailboxId>> getAllowedMailboxIds(MailboxSession mailboxSession, Stream<MailboxId> idList, MailboxACL.Right ... rights) {
        return Flux.fromStream(idList).distinct().filterWhen(this.hasRightsOnMailboxReactive(mailboxSession, rights), 16).collect(ImmutableSet.toImmutableSet());
    }

    public DeleteResult delete(MessageId messageId, List<MailboxId> mailboxIds, MailboxSession mailboxSession) throws MailboxException {
        return (DeleteResult)MailboxReactorUtils.block(this.deleteReactive((List<MessageId>)ImmutableList.of((Object)messageId), mailboxIds, mailboxSession).subscribeOn(Schedulers.elastic()));
    }

    public Mono<DeleteResult> deleteReactive(List<MessageId> messageIds, List<MailboxId> mailboxIds, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return this.assertRightsOnMailboxIds(mailboxIds, mailboxSession, MailboxACL.Right.DeleteMessages).then(messageIdMapper.findReactive(messageIds, MessageMapper.FetchType.METADATA).filter(this.inMailboxes(mailboxIds)).collectList()).flatMap(messageList -> {
            Set found = (Set)messageList.stream().map(Message::getMessageId).collect(ImmutableSet.toImmutableSet());
            Sets.SetView notFound = Sets.difference((Set)ImmutableSet.copyOf((Collection)messageIds), (Set)found);
            DeleteResult result = DeleteResult.builder().addDestroyed((Collection)found).addNotFound((Collection)notFound).build();
            if (!messageList.isEmpty()) {
                return this.deleteWithPreHooks(messageIdMapper, (List<MailboxMessage>)messageList, mailboxSession).thenReturn((Object)result);
            }
            return Mono.just((Object)result);
        });
    }

    public Mono<DeleteResult> delete(List<MessageId> messageIds, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return messageIdMapper.findReactive(messageIds, MessageMapper.FetchType.METADATA).collectList().flatMap(messageList -> this.getAllowedMailboxIds(mailboxSession, messageList.stream().map(MailboxMessage::getMailboxId), MailboxACL.Right.DeleteMessages).flatMap(allowedMailboxIds -> this.deleteInAllowedMailboxes(messageIds, mailboxSession, messageIdMapper, (List<MailboxMessage>)messageList, (ImmutableSet<MailboxId>)allowedMailboxIds)));
    }

    private Mono<DeleteResult> deleteInAllowedMailboxes(List<MessageId> messageIds, MailboxSession mailboxSession, MessageIdMapper messageIdMapper, List<MailboxMessage> messageList, ImmutableSet<MailboxId> allowedMailboxIds) {
        List accessibleMessages = (List)messageList.stream().filter(message -> allowedMailboxIds.contains((Object)message.getMailboxId())).collect(ImmutableList.toImmutableList());
        ImmutableSet accessibleMessageIds = (ImmutableSet)accessibleMessages.stream().map(Message::getMessageId).distinct().collect(ImmutableSet.toImmutableSet());
        Sets.SetView nonAccessibleMessages = Sets.difference((Set)ImmutableSet.copyOf(messageIds), (Set)accessibleMessageIds);
        return this.deleteWithPreHooks(messageIdMapper, accessibleMessages, mailboxSession).thenReturn((Object)DeleteResult.builder().addDestroyed((Collection)accessibleMessageIds).addNotFound((Collection)nonAccessibleMessages).build());
    }

    private Mono<Void> deleteWithPreHooks(MessageIdMapper messageIdMapper, List<MailboxMessage> messageList, MailboxSession mailboxSession) {
        ImmutableList metadataWithMailbox = (ImmutableList)messageList.stream().map(mailboxMessage -> MetadataWithMailboxId.from((MessageMetaData)mailboxMessage.metaData(), (MailboxId)mailboxMessage.getMailboxId())).collect(ImmutableList.toImmutableList());
        return this.preDeletionHooks.runHooks(PreDeletionHook.DeleteOperation.from((List)metadataWithMailbox)).then(this.delete(messageIdMapper, messageList, mailboxSession, (ImmutableList<MetadataWithMailboxId>)metadataWithMailbox));
    }

    private Mono<Void> delete(MessageIdMapper messageIdMapper, List<MailboxMessage> messageList, MailboxSession mailboxSession, ImmutableList<MetadataWithMailboxId> metadataWithMailbox) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        return messageIdMapper.deleteReactive((Multimap<MessageId, MailboxId>)((Multimap)messageList.stream().collect(ImmutableListMultimap.toImmutableListMultimap(Message::getMessageId, MailboxMessage::getMailboxId)))).then(Flux.fromIterable(metadataWithMailbox).flatMap(metadataWithMailboxId -> mailboxMapper.findMailboxById(metadataWithMailboxId.getMailboxId()).flatMap(mailbox -> this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)mailbox)).addMetaData(metadataWithMailboxId.getMessageMetaData())).build(), (RegistrationKey)new MailboxIdRegistrationKey(metadataWithMailboxId.getMailboxId()))), 16).then());
    }

    public void setInMailboxes(MessageId messageId, Collection<MailboxId> targetMailboxIds, MailboxSession mailboxSession) throws MailboxException {
        MailboxReactorUtils.block(this.setInMailboxesReactive(messageId, targetMailboxIds, mailboxSession).subscribeOn(Schedulers.elastic()));
    }

    public Mono<Void> setInMailboxesReactive(MessageId messageId, Collection<MailboxId> targetMailboxIds, MailboxSession mailboxSession) {
        return this.findRelatedMailboxMessages(messageId, mailboxSession).flatMap(currentMailboxMessages -> this.messageMovesWithMailbox(MessageMoves.builder().targetMailboxIds((Iterable)targetMailboxIds).previousMailboxIds(StoreMessageIdManager.toMailboxIds(currentMailboxMessages)).build(), mailboxSession).flatMap(Throwing.function(messageMove -> {
            MessageMovesWithMailbox refined = messageMove.filterPrevious(this.hasRightsOnMailbox(mailboxSession, MailboxACL.Right.Read));
            if (messageMove.getPreviousMailboxes().isEmpty()) {
                LOGGER.info("Tried to access {} not accessible for {}", (Object)messageId, (Object)mailboxSession.getUser().asString());
                return Mono.empty();
            }
            if (refined.isChange()) {
                return this.applyMessageMoves(mailboxSession, (List<MailboxMessage>)currentMailboxMessages, refined);
            }
            return Mono.empty();
        }).sneakyThrow()));
    }

    public void setInMailboxesNoCheck(MessageId messageId, MailboxId targetMailboxId, MailboxSession mailboxSession) throws MailboxException {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        List<MailboxMessage> currentMailboxMessages = messageIdMapper.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.METADATA);
        MailboxReactorUtils.block(this.messageMovesWithMailbox(MessageMoves.builder().targetMailboxIds(new MailboxId[]{targetMailboxId}).previousMailboxIds(StoreMessageIdManager.toMailboxIds(currentMailboxMessages)).build(), mailboxSession).flatMap(messageMove -> {
            if (messageMove.isChange()) {
                return this.applyMessageMoveNoMailboxChecks(mailboxSession, currentMailboxMessages, (MessageMovesWithMailbox)messageMove);
            }
            return Mono.empty();
        }).subscribeOn(Schedulers.elastic()));
    }

    private Mono<List<MailboxMessage>> findRelatedMailboxMessages(MessageId messageId, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return messageIdMapper.findReactive((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.METADATA).collect(ImmutableList.toImmutableList());
    }

    private Mono<Void> applyMessageMoves(MailboxSession mailboxSession, List<MailboxMessage> currentMailboxMessages, MessageMovesWithMailbox messageMoves) throws MailboxNotFoundException {
        this.assertRightsOnMailboxes(messageMoves.addedMailboxes(), mailboxSession, MailboxACL.Right.Insert);
        this.assertRightsOnMailboxes(messageMoves.removedMailboxes(), mailboxSession, MailboxACL.Right.DeleteMessages);
        this.assertRightsOnMailboxes((Collection<Mailbox>)messageMoves.getTargetMailboxes(), mailboxSession, MailboxACL.Right.Read);
        return this.applyMessageMoveNoMailboxChecks(mailboxSession, currentMailboxMessages, messageMoves);
    }

    private Mono<Void> applyMessageMoveNoMailboxChecks(MailboxSession mailboxSession, List<MailboxMessage> currentMailboxMessages, MessageMovesWithMailbox messageMoves) {
        Optional mailboxMessage = currentMailboxMessages.stream().findAny();
        if (mailboxMessage.isEmpty()) {
            return Mono.error((Throwable)new MailboxNotFoundException("can't load message"));
        }
        List messagesToRemove = (List)currentMailboxMessages.stream().flatMap(message -> messageMoves.removedMailboxes().stream().filter(mailbox -> mailbox.getMailboxId().equals(message.getMailboxId())).map(mailbox -> Pair.of((Object)message, (Object)mailbox))).collect(ImmutableList.toImmutableList());
        return this.validateQuota(messageMoves, (MailboxMessage)mailboxMessage.get()).then(this.addMessageToMailboxes((MailboxMessage)mailboxMessage.get(), messageMoves.addedMailboxes(), mailboxSession)).then(this.removeMessageFromMailboxes(((MailboxMessage)mailboxMessage.get()).getMessageId(), messagesToRemove, mailboxSession)).then(this.eventBus.dispatch((Event)EventFactory.moved().session(mailboxSession).messageMoves(messageMoves.asMessageMoves()).messageId(((MailboxMessage)mailboxMessage.get()).getMessageId()).build(), (Set)messageMoves.impactedMailboxes().map(Mailbox::getMailboxId).map(MailboxIdRegistrationKey::new).collect(ImmutableSet.toImmutableSet())));
    }

    private Mono<Void> removeMessageFromMailboxes(MessageId messageId, List<Pair<MailboxMessage, Mailbox>> messages, MailboxSession mailboxSession) {
        if (messages.isEmpty()) {
            return Mono.empty();
        }
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        ImmutableList mailboxIds = (ImmutableList)messages.stream().map(pair -> ((Mailbox)pair.getRight()).getMailboxId()).collect(ImmutableList.toImmutableList());
        return Mono.from(messageIdMapper.deleteReactive(messageId, (Collection<MailboxId>)mailboxIds)).then(Flux.fromIterable(messages).flatMap(message -> this.eventBus.dispatch((Event)((EventFactory.ExpungedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.expunged().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)message.getRight())).addMetaData(((MailboxMessage)message.getLeft()).metaData())).build(), (RegistrationKey)new MailboxIdRegistrationKey(((Mailbox)message.getRight()).getMailboxId())), 16).then());
    }

    private Mono<Void> dispatchFlagsChange(MailboxSession mailboxSession, MailboxId mailboxId, ImmutableList<UpdatedFlags> updatedFlags, List<Mailbox> knownMailboxes) {
        if (updatedFlags.stream().anyMatch(UpdatedFlags::flagsChanged)) {
            Mailbox mailbox = knownMailboxes.stream().filter(knownMailbox -> knownMailbox.getMailboxId().equals(mailboxId)).findFirst().orElseGet(Throwing.supplier(() -> (Mailbox)MailboxReactorUtils.block(this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId).subscribeOn(Schedulers.elastic()))).sneakyThrow());
            return this.eventBus.dispatch((Event)((EventFactory.FlagsUpdatedFinalStage)((EventFactory.RequireUpdatedFlags)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.flagsUpdated().randomEventId()).mailboxSession(mailboxSession)).mailbox(mailbox)).updatedFlags(updatedFlags)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailboxId));
        }
        return Mono.empty();
    }

    private Mono<Void> validateQuota(MessageMovesWithMailbox messageMoves, MailboxMessage mailboxMessage) {
        Map<QuotaRoot, Integer> messageCountByQuotaRoot = this.buildMapQuotaRoot(messageMoves);
        return Flux.fromIterable(messageCountByQuotaRoot.entrySet()).filter(entry -> (Integer)entry.getValue() > 0).flatMap(entry -> Mono.from((Publisher)this.quotaManager.getQuotasReactive((QuotaRoot)entry.getKey())).map(quotas -> new QuotaChecker((QuotaManager.Quotas)quotas, (QuotaRoot)entry.getKey())).handle((quotaChecker, sink) -> {
            Integer additionalCopyCount = (Integer)entry.getValue();
            long additionalOccupiedSpace = (long)additionalCopyCount.intValue() * mailboxMessage.getFullContentOctets();
            try {
                quotaChecker.tryAddition(additionalCopyCount.intValue(), additionalOccupiedSpace);
            }
            catch (OverQuotaException e) {
                sink.error((Throwable)e);
            }
        })).then();
    }

    private Map<QuotaRoot, Integer> buildMapQuotaRoot(MessageMovesWithMailbox messageMoves) {
        try {
            int currentCount;
            QuotaRoot quotaRoot;
            HashMap<QuotaRoot, Integer> messageCountByQuotaRoot = new HashMap<QuotaRoot, Integer>();
            for (Mailbox mailbox : messageMoves.addedMailboxes()) {
                quotaRoot = this.quotaRootResolver.getQuotaRoot(mailbox);
                currentCount = Optional.ofNullable((Integer)messageCountByQuotaRoot.get(quotaRoot)).orElse(0);
                messageCountByQuotaRoot.put(quotaRoot, currentCount + 1);
            }
            for (Mailbox mailbox : messageMoves.removedMailboxes()) {
                quotaRoot = this.quotaRootResolver.getQuotaRoot(mailbox);
                currentCount = Optional.ofNullable((Integer)messageCountByQuotaRoot.get(quotaRoot)).orElse(0);
                messageCountByQuotaRoot.put(quotaRoot, currentCount - 1);
            }
            return messageCountByQuotaRoot;
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private Mono<Void> addMessageToMailboxes(MailboxMessage mailboxMessage, Set<Mailbox> mailboxes, MailboxSession mailboxSession) {
        MessageIdMapper messageIdMapper = this.mailboxSessionMapperFactory.getMessageIdMapper(mailboxSession);
        return Flux.fromIterable(mailboxes).flatMap(Throwing.function(mailbox -> {
            MailboxACL.Rfc4314Rights myRights = this.rightManager.myRights(mailbox, mailboxSession);
            boolean shouldPreserveFlags = myRights.contains(MailboxACL.Right.Write);
            MailboxMessage copy = mailboxMessage.copy((Mailbox)mailbox);
            copy.setFlags(FlagsFactory.builder().flags(mailboxMessage.createFlags()).filteringFlags(FlagsFilter.builder().systemFlagFilter(f -> shouldPreserveFlags).userFlagFilter(f -> shouldPreserveFlags).build()).build());
            return this.save(messageIdMapper, copy, (Mailbox)mailbox).flatMap(metadata -> this.eventBus.dispatch((Event)((EventFactory.AddedFinalStage)((EventFactory.RequireMetadata)((EventFactory.RequireMailbox)((EventFactory.RequireSession)EventFactory.added().randomEventId()).mailboxSession(mailboxSession)).mailbox((Mailbox)mailbox)).addMetaData((MessageMetaData)metadata)).build(), (RegistrationKey)new MailboxIdRegistrationKey(mailbox.getMailboxId())));
        }).sneakyThrow()).then();
    }

    private Mono<MessageMetaData> save(MessageIdMapper messageIdMapper, MailboxMessage mailboxMessage, Mailbox mailbox) {
        return Mono.zip(this.mailboxSessionMapperFactory.getModSeqProvider().nextModSeqReactive(mailbox.getMailboxId()), this.mailboxSessionMapperFactory.getUidProvider().nextUidReactive(mailbox.getMailboxId())).flatMap(modSeqAndUid -> {
            mailboxMessage.setModSeq((ModSeq)modSeqAndUid.getT1());
            mailboxMessage.setUid((MessageUid)modSeqAndUid.getT2());
            return messageIdMapper.copyInMailboxReactive(mailboxMessage, mailbox).thenReturn((Object)mailboxMessage.metaData());
        });
    }

    private ThrowingFunction<MailboxMessage, MessageResult> messageResultConverter(FetchGroup fetchGroup) {
        return input -> ResultUtils.loadMessageResult(input, fetchGroup);
    }

    private Predicate<MailboxMessage> inMailboxes(Collection<MailboxId> mailboxIds) {
        return mailboxMessage -> mailboxIds.contains(mailboxMessage.getMailboxId());
    }

    private Function<MailboxId, Mono<Boolean>> hasRightsOnMailboxReactive(MailboxSession session, MailboxACL.Right ... rights) {
        return mailboxId -> Mono.from((Publisher)this.rightManager.myRights(mailboxId, session)).map(myRights -> myRights.contains(rights)).onErrorResume(any -> Mono.just((Object)false));
    }

    private Predicate<Mailbox> hasRightsOnMailbox(MailboxSession session, MailboxACL.Right ... rights) {
        return mailbox -> this.rightManager.myRights(mailbox, session).contains(rights);
    }

    private Mono<Void> assertRightsOnMailboxIds(Collection<MailboxId> mailboxIds, MailboxSession mailboxSession, MailboxACL.Right ... rights) {
        return Flux.fromIterable(mailboxIds).filterWhen(this.hasRightsOnMailboxReactive(mailboxSession, rights).andThen(result -> result.map(FunctionalUtils.negate())), 16).next().flatMap(mailboxForbidden -> {
            LOGGER.info("Mailbox with Id {} does not belong to {}", mailboxForbidden, (Object)mailboxSession.getUser().asString());
            return Mono.error((Throwable)new MailboxNotFoundException(mailboxForbidden));
        }).then();
    }

    private void assertRightsOnMailboxes(Collection<Mailbox> mailboxes, MailboxSession mailboxSession, MailboxACL.Right ... rights) throws MailboxNotFoundException {
        Optional<Mailbox> firstForbiddenMailbox = mailboxes.stream().filter(Predicate.not(this.hasRightsOnMailbox(mailboxSession, rights))).findFirst();
        if (firstForbiddenMailbox.isPresent()) {
            MailboxId mailboxId = firstForbiddenMailbox.get().getMailboxId();
            LOGGER.info("Mailbox with Id {} does not belong to {}", (Object)mailboxId, (Object)mailboxSession.getUser().asString());
            throw new MailboxNotFoundException(firstForbiddenMailbox.get().generateAssociatedPath());
        }
    }

    private Mono<MessageMovesWithMailbox> messageMovesWithMailbox(MessageMoves messageMoves, MailboxSession session) {
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mono target = Flux.fromIterable((Iterable)messageMoves.getTargetMailboxIds()).flatMap(mailboxMapper::findMailboxById, 16).collect(ImmutableList.toImmutableList());
        Mono previous = Flux.fromIterable((Iterable)messageMoves.getPreviousMailboxIds()).flatMap(mailboxMapper::findMailboxById, 16).collect(ImmutableList.toImmutableList());
        return target.zipWith(previous).map(tuple -> MessageMovesWithMailbox.builder().targetMailboxes((Iterable)tuple.getT1()).previousMailboxes((Iterable)tuple.getT2()).build());
    }
}

