/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorUtils {
    public static <T> Mono<T> executeAndEmpty(Runnable runnable) {
        return Mono.fromRunnable(runnable).then(Mono.empty());
    }

    public static InputStream toInputStream(Flux<ByteBuffer> byteArrays) {
        return new StreamInputStream(byteArrays.toStream(1));
    }

    private static class StreamInputStream
    extends InputStream {
        private static final int NO_MORE_DATA = -1;
        private final Stream<ByteBuffer> source;
        private final Spliterator<ByteBuffer> spliterator;
        private Optional<ByteBuffer> currentItemByteStream;

        StreamInputStream(Stream<ByteBuffer> source) {
            this.source = source;
            this.spliterator = source.spliterator();
            this.currentItemByteStream = Optional.empty();
        }

        @Override
        public int read() {
            try {
                if (!this.dataAvailableToRead()) {
                    this.switchToNextChunk();
                }
                if (!this.dataAvailableToRead()) {
                    this.source.close();
                    return -1;
                }
                return this.currentItemByteStream.filter(Buffer::hasRemaining).map(buffer -> buffer.get() & 0xFF).orElseGet(this::readNextChunk);
            }
            catch (Throwable t) {
                this.source.close();
                throw t;
            }
        }

        private boolean dataAvailableToRead() {
            return this.currentItemByteStream.isPresent();
        }

        private void switchToNextChunk() {
            this.spliterator.tryAdvance(bytes -> {
                this.currentItemByteStream = Optional.of(bytes);
            });
        }

        private Integer readNextChunk() {
            this.currentItemByteStream = Optional.empty();
            return this.read();
        }

        @Override
        public void close() throws IOException {
            try {
                this.source.close();
            }
            finally {
                super.close();
            }
        }
    }
}

