/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TemplateFilter
extends SchemaFilter {
    private final String templateName;
    private final boolean isEqual;

    public TemplateFilter(String templateName, boolean isEqual) {
        this.templateName = templateName;
        this.isEqual = isEqual;
    }

    public TemplateFilter(ByteBuffer byteBuffer) {
        this.templateName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isEqual = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitTemplateFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.TEMPLATE_FILTER;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.templateName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isEqual, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.templateName, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isEqual, (OutputStream)stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateFilter that = (TemplateFilter)o;
        return Objects.equals(this.templateName, that.templateName) && Objects.equals(this.isEqual, that.isEqual);
    }

    public int hashCode() {
        return Objects.hash(this.templateName, this.isEqual);
    }
}

