/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.security;

import org.apache.iotdb.commons.auth.entity.PrivilegeType;

public enum TableModelPrivilege {
    MANAGE_USER,
    MANAGE_ROLE,
    CREATE,
    DROP,
    ALTER,
    SELECT,
    INSERT,
    DELETE;


    PrivilegeType getPrivilegeType() {
        switch (this) {
            case MANAGE_ROLE: {
                return PrivilegeType.MANAGE_ROLE;
            }
            case MANAGE_USER: {
                return PrivilegeType.MANAGE_USER;
            }
            case CREATE: {
                return PrivilegeType.CREATE;
            }
            case DROP: {
                return PrivilegeType.DROP;
            }
            case ALTER: {
                return PrivilegeType.ALTER;
            }
            case SELECT: {
                return PrivilegeType.SELECT;
            }
            case INSERT: {
                return PrivilegeType.INSERT;
            }
            case DELETE: {
                return PrivilegeType.DELETE;
            }
        }
        throw new IllegalStateException("Unexpected value:" + (Object)((Object)this));
    }

    public static TableModelPrivilege getTableModelType(PrivilegeType privilegeType) {
        switch (privilegeType) {
            case MANAGE_ROLE: {
                return MANAGE_ROLE;
            }
            case MANAGE_USER: {
                return MANAGE_USER;
            }
            case CREATE: {
                return CREATE;
            }
            case DROP: {
                return DROP;
            }
            case ALTER: {
                return ALTER;
            }
            case SELECT: {
                return SELECT;
            }
            case INSERT: {
                return INSERT;
            }
            case DELETE: {
                return DELETE;
            }
        }
        throw new IllegalStateException("Unexpected value:" + privilegeType);
    }
}

