/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.file.metadata.TsFileMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.chunk.TableChunkReader;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TsFileInsertionEventTableParserTabletIterator
implements Iterator<Tablet> {
    private final long startTime;
    private final long endTime;
    private final TsFileSequenceReader reader;
    private final IMetadataQuerier metadataQuerier;
    private final TsFileMetadata fileMetadata;
    private final Iterator<Map.Entry<String, TableSchema>> filteredTableSchemaIterator;
    private final PipeMemoryBlock allocatedMemoryBlockForTablet;
    private final PipeMemoryBlock allocatedMemoryBlockForBatchData;
    private final PipeMemoryBlock allocatedMemoryBlockForChunk;
    private final PipeMemoryBlock allocatedMemoryBlockForChunkMeta;
    private final PipeMemoryBlock allocatedMemoryBlockForTableSchema;
    private IChunkReader chunkReader;
    private BatchData batchData;
    private Iterator<Pair<IDeviceID, MetadataIndexNode>> deviceMetaIterator;
    private Iterator<AbstractAlignedChunkMetadata> chunkMetadataList;
    private Iterator<IChunkMetadata> chunkMetadata;
    private AbstractAlignedChunkMetadata currentChunkMetadata;
    private Chunk timeChunk;
    private long timeChunkSize;
    private int offset;
    private String tableName;
    private IDeviceID deviceID;
    private List<ColumnCategory> columnTypes;
    private List<String> measurementList;
    private List<TSDataType> dataTypeList;
    private int deviceIdSize;
    private boolean isSameTableName;
    private boolean isSameDeviceID;

    public TsFileInsertionEventTableParserTabletIterator(TsFileSequenceReader tsFileSequenceReader, Predicate<Map.Entry<String, TableSchema>> predicate, PipeMemoryBlock allocatedMemoryBlockForTablet, PipeMemoryBlock allocatedMemoryBlockForBatchData, PipeMemoryBlock allocatedMemoryBlockForChunk, PipeMemoryBlock allocatedMemoryBlockForChunkMeta, PipeMemoryBlock allocatedMemoryBlockForTableSchema, long startTime, long endTime) throws IOException {
        this.startTime = startTime;
        this.endTime = endTime;
        this.reader = tsFileSequenceReader;
        this.metadataQuerier = new MetadataQuerierByFileImpl(this.reader);
        this.fileMetadata = this.metadataQuerier.getWholeFileMetadata();
        List tableSchemaList = this.fileMetadata.getTableSchemaMap().entrySet().stream().filter(predicate).collect(Collectors.toList());
        this.allocatedMemoryBlockForTablet = allocatedMemoryBlockForTablet;
        this.allocatedMemoryBlockForBatchData = allocatedMemoryBlockForBatchData;
        this.allocatedMemoryBlockForChunk = allocatedMemoryBlockForChunk;
        this.allocatedMemoryBlockForChunkMeta = allocatedMemoryBlockForChunkMeta;
        this.allocatedMemoryBlockForTableSchema = allocatedMemoryBlockForTableSchema;
        long tableSchemaSize = this.fileMetadata.getBloomFilter().getRetainedSizeInBytes();
        for (Map.Entry tableSchemaEntry : tableSchemaList) {
            PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTableSchema, tableSchemaSize += (long)((String)tableSchemaEntry.getKey()).length() + PipeMemoryWeightUtil.calculateTableSchemaBytesUsed((TableSchema)tableSchemaEntry.getValue()));
        }
        this.filteredTableSchemaIterator = tableSchemaList.iterator();
    }

    @Override
    public boolean hasNext() {
        try {
            State state = State.CHECK_DATA;
            while (true) {
                switch (state) {
                    case CHECK_DATA: {
                        if (this.batchData != null && this.batchData.hasCurrent()) {
                            return true;
                        }
                    }
                    case INIT_DATA: {
                        if (this.chunkReader != null && this.chunkReader.hasNextSatisfiedPage()) {
                            this.batchData = this.chunkReader.nextPageData();
                            PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForBatchData, PipeMemoryWeightUtil.calculateBatchDataRamBytesUsed(this.batchData));
                            state = State.CHECK_DATA;
                            break;
                        }
                    }
                    case INIT_CHUNK_READER: {
                        if (this.currentChunkMetadata != null || this.chunkMetadataList != null && this.chunkMetadataList.hasNext()) {
                            if (this.currentChunkMetadata == null) {
                                this.currentChunkMetadata = this.chunkMetadataList.next();
                                this.timeChunk = null;
                                this.offset = 0;
                            }
                            this.initChunkReader(this.currentChunkMetadata);
                            state = State.INIT_DATA;
                            break;
                        }
                    }
                    case INIT_CHUNK_METADATA: {
                        if (this.deviceMetaIterator != null && this.deviceMetaIterator.hasNext()) {
                            Pair<IDeviceID, MetadataIndexNode> pair = this.deviceMetaIterator.next();
                            long size = 0L;
                            List iChunkMetadataList = this.reader.getAlignedChunkMetadata((IDeviceID)pair.left, true);
                            Iterator chunkMetadataIterator = iChunkMetadataList.iterator();
                            while (chunkMetadataIterator.hasNext()) {
                                AbstractAlignedChunkMetadata alignedChunkMetadata = (AbstractAlignedChunkMetadata)chunkMetadataIterator.next();
                                if (alignedChunkMetadata == null) {
                                    throw new PipeException("Table model tsfile parsing does not support this type of ChunkMeta");
                                }
                                if (alignedChunkMetadata.getEndTime() < this.startTime || alignedChunkMetadata.getStartTime() > this.endTime) {
                                    chunkMetadataIterator.remove();
                                    continue;
                                }
                                PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForChunkMeta, size += PipeMemoryWeightUtil.calculateAlignedChunkMetaBytesUsed(alignedChunkMetadata));
                            }
                            this.deviceID = (IDeviceID)pair.getLeft();
                            this.chunkMetadataList = iChunkMetadataList.iterator();
                            state = State.INIT_CHUNK_READER;
                            break;
                        }
                    }
                    case INIT_DEVICE_META: {
                        if (this.filteredTableSchemaIterator != null && this.filteredTableSchemaIterator.hasNext()) {
                            Map.Entry<String, TableSchema> entry = this.filteredTableSchemaIterator.next();
                            this.tableName = entry.getKey();
                            TableSchema tableSchema = entry.getValue();
                            this.isSameTableName = false;
                            MetadataIndexNode tableRoot = this.fileMetadata.getTableMetadataIndexNode(this.tableName);
                            this.deviceMetaIterator = this.metadataQuerier.deviceIterator(tableRoot, null);
                            int columnSchemaSize = tableSchema.getColumnSchemas().size();
                            this.dataTypeList = new ArrayList<TSDataType>();
                            this.columnTypes = new ArrayList<ColumnCategory>();
                            this.measurementList = new ArrayList<String>();
                            for (int i = 0; i < columnSchemaSize; ++i) {
                                IMeasurementSchema schema = (IMeasurementSchema)tableSchema.getColumnSchemas().get(i);
                                ColumnCategory columnCategory = (ColumnCategory)tableSchema.getColumnTypes().get(i);
                                if (schema == null || schema.getMeasurementName() == null || schema.getMeasurementName().isEmpty()) continue;
                                String measurementName = schema.getMeasurementName();
                                if (!ColumnCategory.TAG.equals((Object)columnCategory)) continue;
                                this.columnTypes.add(ColumnCategory.TAG);
                                this.measurementList.add(measurementName);
                                this.dataTypeList.add(schema.getType());
                            }
                            this.deviceIdSize = this.dataTypeList.size();
                            state = State.INIT_CHUNK_METADATA;
                            break;
                        }
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Tablet next() {
        return this.buildNextTablet();
    }

    private Tablet buildNextTablet() {
        Tablet tablet = null;
        boolean isFirstRow = true;
        while (this.hasNext() && (isFirstRow || this.isSameTableName && this.isSameDeviceID)) {
            if (this.batchData.currentTime() >= this.startTime && this.batchData.currentTime() <= this.endTime) {
                int rowIndex;
                if (isFirstRow) {
                    this.isSameTableName = true;
                    this.isSameDeviceID = true;
                    Pair<Integer, Integer> rowCountAndMemorySize = PipeMemoryWeightUtil.calculateTabletRowCountAndMemory(this.batchData);
                    PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
                    tablet = new Tablet(this.tableName, this.measurementList, this.dataTypeList, this.columnTypes, ((Integer)rowCountAndMemorySize.getLeft()).intValue());
                    tablet.initBitMaps();
                    isFirstRow = false;
                }
                if ((rowIndex = tablet.getRowSize()) >= tablet.getMaxRowNumber()) break;
                tablet.addTimestamp(rowIndex, this.batchData.currentTime());
                this.fillMeasurementValueColumns(this.batchData, tablet, rowIndex);
                this.fillDeviceIdColumns(this.deviceID, tablet, rowIndex);
            }
            if (this.batchData == null) continue;
            this.batchData.next();
        }
        if (isFirstRow) {
            PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForTablet, 0L);
            tablet = new Tablet(this.tableName, this.measurementList, this.dataTypeList, this.columnTypes, 0);
            tablet.initBitMaps();
        }
        return tablet;
    }

    private void initChunkReader(AbstractAlignedChunkMetadata alignedChunkMetadata) throws IOException {
        if (Objects.isNull(this.timeChunk)) {
            this.timeChunk = this.reader.readMemChunk((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
            this.timeChunkSize = PipeMemoryWeightUtil.calculateChunkRamBytesUsed(this.timeChunk);
            PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForChunk, this.timeChunkSize);
        }
        this.timeChunk.getData().rewind();
        long size = this.timeChunkSize;
        ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
        this.isSameDeviceID = false;
        ArrayList<ColumnCategory> categories = new ArrayList<ColumnCategory>(this.deviceIdSize);
        for (int i = 0; i < this.deviceIdSize; ++i) {
            categories.add(ColumnCategory.TAG);
        }
        this.columnTypes = categories;
        this.measurementList.subList(this.deviceIdSize, this.measurementList.size()).clear();
        this.dataTypeList.subList(this.deviceIdSize, this.dataTypeList.size()).clear();
        while (this.offset < alignedChunkMetadata.getValueChunkMetadataList().size()) {
            IChunkMetadata metadata = (IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(this.offset);
            if (metadata != null) {
                Chunk chunk = this.reader.readMemChunk((ChunkMetadata)metadata);
                if ((size += PipeMemoryWeightUtil.calculateChunkRamBytesUsed(chunk)) > this.allocatedMemoryBlockForChunk.getMemoryUsageInBytes()) {
                    if (!valueChunkList.isEmpty()) break;
                    PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlockForChunk, size);
                    this.columnTypes.add(ColumnCategory.FIELD);
                    this.measurementList.add(metadata.getMeasurementUid());
                    this.dataTypeList.add(metadata.getDataType());
                    valueChunkList.add(chunk);
                    ++this.offset;
                    break;
                }
                this.columnTypes.add(ColumnCategory.FIELD);
                this.measurementList.add(metadata.getMeasurementUid());
                this.dataTypeList.add(metadata.getDataType());
                valueChunkList.add(chunk);
            }
            ++this.offset;
        }
        if (this.offset >= alignedChunkMetadata.getValueChunkMetadataList().size()) {
            this.currentChunkMetadata = null;
        }
        this.chunkReader = new TableChunkReader(this.timeChunk, valueChunkList, null);
    }

    private void fillMeasurementValueColumns(BatchData data, Tablet tablet, int rowIndex) {
        TsPrimitiveType[] primitiveTypes = data.getVector();
        int size = this.dataTypeList.size();
        block9: for (int i = this.deviceIdSize; i < size; ++i) {
            TsPrimitiveType primitiveType = primitiveTypes[i - this.deviceIdSize];
            if (primitiveType == null) continue;
            switch (this.dataTypeList.get(i)) {
                case BOOLEAN: {
                    tablet.addValue(rowIndex, i, primitiveType.getBoolean());
                    continue block9;
                }
                case INT32: {
                    tablet.addValue(rowIndex, i, primitiveType.getInt());
                    continue block9;
                }
                case DATE: {
                    tablet.addValue(rowIndex, i, DateUtils.parseIntToLocalDate((int)primitiveType.getInt()));
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    tablet.addValue(rowIndex, i, primitiveType.getLong());
                    continue block9;
                }
                case FLOAT: {
                    tablet.addValue(rowIndex, i, primitiveType.getFloat());
                    continue block9;
                }
                case DOUBLE: {
                    tablet.addValue(rowIndex, i, primitiveType.getDouble());
                    continue block9;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    tablet.addValue(rowIndex, i, primitiveType.getBinary().getValues());
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException("UnSupported" + primitiveType.getDataType());
                }
            }
        }
    }

    private void fillDeviceIdColumns(IDeviceID deviceID, Tablet tablet, int rowIndex) {
        String[] deviceIdSegments = (String[])deviceID.getSegments();
        int totalColumns = deviceIdSegments.length;
        for (int i = 1; i < totalColumns; ++i) {
            if (deviceIdSegments[i] == null) continue;
            tablet.addValue(rowIndex, i - 1, deviceIdSegments[i]);
        }
    }

    private static enum State {
        CHECK_DATA,
        INIT_DATA,
        INIT_CHUNK_READER,
        INIT_CHUNK_METADATA,
        INIT_DEVICE_META;

    }
}

