/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper.CastFunctionHelper;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;

public abstract class AbstractCastFunctionColumnTransformer
extends UnaryColumnTransformer {
    private final ZoneId zoneId;

    protected AbstractCastFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, ZoneId zoneId) {
        super(returnType, childColumnTransformer);
        this.zoneId = zoneId;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        Type childType = this.childColumnTransformer.getType();
        TypeEnum sourceType = childType.getTypeEnum();
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, sourceType, childType, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        Type childType = this.childColumnTransformer.getType();
        TypeEnum sourceType = childType.getTypeEnum();
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, sourceType, childType, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    protected abstract void transform(Column var1, ColumnBuilder var2, TypeEnum var3, Type var4, int var5);

    protected void cast(ColumnBuilder columnBuilder, int value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                this.returnType.writeInt(columnBuilder, value);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.returnType.writeLong(columnBuilder, (long)value);
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, (float)value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0);
                break;
            }
            case TEXT: 
            case STRING: {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)String.valueOf(value)));
                break;
            }
            case BLOB: {
                this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.intToBytes((int)value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
            }
        }
    }

    protected void castDate(ColumnBuilder columnBuilder, int value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                this.returnType.writeInt(columnBuilder, value);
                break;
            }
            case INT64: {
                this.returnType.writeLong(columnBuilder, (long)value);
                break;
            }
            case TIMESTAMP: {
                this.returnType.writeLong(columnBuilder, DateTimeUtils.correctPrecision(DateUtils.parseIntToTimestamp((int)value, (ZoneId)this.zoneId)));
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, (float)value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0);
                break;
            }
            case TEXT: 
            case STRING: {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)DateUtils.formatDate((int)value)));
                break;
            }
            case BLOB: {
                this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.intToBytes((int)value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
            }
        }
    }

    protected void castTimestamp(ColumnBuilder columnBuilder, long value) {
        try {
            switch (this.returnType.getTypeEnum()) {
                case INT32: {
                    this.returnType.writeInt(columnBuilder, CastFunctionHelper.castLongToInt(value));
                    break;
                }
                case DATE: {
                    this.returnType.writeInt(columnBuilder, DateUtils.parseDateExpressionToInt((LocalDate)DateTimeUtils.convertToLocalDate(value, this.zoneId)).intValue());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.returnType.writeLong(columnBuilder, value);
                    break;
                }
                case FLOAT: {
                    this.returnType.writeFloat(columnBuilder, (float)value);
                    break;
                }
                case DOUBLE: {
                    this.returnType.writeDouble(columnBuilder, (double)value);
                    break;
                }
                case BOOLEAN: {
                    this.returnType.writeBoolean(columnBuilder, value != 0L);
                    break;
                }
                case TEXT: 
                case STRING: {
                    this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)DateTimeUtils.convertLongToDate(value, this.zoneId)));
                    break;
                }
                case BLOB: {
                    this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.longToBytes((long)value)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
                }
            }
        }
        catch (DateTimeParseException e) {
            throw new IoTDBRuntimeException("Year must be between 1000 and 9999.", TSStatusCode.DATE_OUT_OF_RANGE.getStatusCode(), true);
        }
    }

    protected void cast(ColumnBuilder columnBuilder, long value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                this.returnType.writeInt(columnBuilder, CastFunctionHelper.castLongToInt(value));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.returnType.writeLong(columnBuilder, value);
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, (float)value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0L);
                break;
            }
            case TEXT: 
            case STRING: {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)String.valueOf(value)));
                break;
            }
            case BLOB: {
                this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.longToBytes((long)value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
            }
        }
    }

    protected void cast(ColumnBuilder columnBuilder, float value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                this.returnType.writeInt(columnBuilder, CastFunctionHelper.castFloatToInt(value));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.returnType.writeLong(columnBuilder, CastFunctionHelper.castFloatToLong(value));
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, value);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, (double)value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0.0f);
                break;
            }
            case TEXT: 
            case STRING: {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)String.valueOf(value)));
                break;
            }
            case BLOB: {
                this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.floatToBytes((float)value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
            }
        }
    }

    protected void cast(ColumnBuilder columnBuilder, double value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                this.returnType.writeInt(columnBuilder, CastFunctionHelper.castDoubleToInt(value));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.returnType.writeLong(columnBuilder, CastFunctionHelper.castDoubleToLong(value));
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, CastFunctionHelper.castDoubleToFloat(value));
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, value);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value != 0.0);
                break;
            }
            case TEXT: 
            case STRING: {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)String.valueOf(value)));
                break;
            }
            case BLOB: {
                this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.doubleToBytes((double)value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
            }
        }
    }

    protected void cast(ColumnBuilder columnBuilder, boolean value) {
        switch (this.returnType.getTypeEnum()) {
            case INT32: 
            case DATE: {
                this.returnType.writeInt(columnBuilder, value ? 1 : 0);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.returnType.writeLong(columnBuilder, value ? 1L : 0L);
                break;
            }
            case FLOAT: {
                this.returnType.writeFloat(columnBuilder, value ? 1.0f : 0.0f);
                break;
            }
            case DOUBLE: {
                this.returnType.writeDouble(columnBuilder, value ? 1.0 : 0.0);
                break;
            }
            case BOOLEAN: {
                this.returnType.writeBoolean(columnBuilder, value);
                break;
            }
            case TEXT: 
            case STRING: {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)String.valueOf(value)));
                break;
            }
            case BLOB: {
                this.returnType.writeBinary(columnBuilder, new Binary(BytesUtils.boolToBytes((boolean)value)));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
            }
        }
    }

    protected void castString(ColumnBuilder columnBuilder, Binary value) {
        String stringValue = value.getStringValue(TSFileConfig.STRING_CHARSET);
        try {
            switch (this.returnType.getTypeEnum()) {
                case INT32: {
                    this.returnType.writeInt(columnBuilder, Integer.parseInt(stringValue));
                    break;
                }
                case DATE: {
                    this.returnType.writeInt(columnBuilder, DateUtils.parseDateExpressionToInt((String)stringValue).intValue());
                    break;
                }
                case INT64: {
                    this.returnType.writeLong(columnBuilder, Long.parseLong(stringValue));
                    break;
                }
                case TIMESTAMP: {
                    this.returnType.writeLong(columnBuilder, DateTimeUtils.convertDatetimeStrToLong(stringValue, this.zoneId));
                    break;
                }
                case FLOAT: {
                    this.returnType.writeFloat(columnBuilder, CastFunctionHelper.castTextToFloat(stringValue));
                    break;
                }
                case DOUBLE: {
                    this.returnType.writeDouble(columnBuilder, CastFunctionHelper.castTextToDouble(stringValue));
                    break;
                }
                case BOOLEAN: {
                    this.returnType.writeBoolean(columnBuilder, CastFunctionHelper.castTextToBoolean(stringValue));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.returnType.writeBinary(columnBuilder, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
                }
            }
        }
        catch (NumberFormatException | DateTimeParseException e) {
            throw new SemanticException(String.format("Cannot cast %s to %s type", stringValue, this.returnType.getDisplayName()));
        }
    }

    protected void castBlob(ColumnBuilder columnBuilder, Binary value) {
        String stringValue = BytesUtils.parseBlobByteArrayToString((byte[])value.getValues());
        try {
            switch (this.returnType.getTypeEnum()) {
                case INT32: {
                    this.returnType.writeInt(columnBuilder, Integer.parseInt(stringValue));
                    break;
                }
                case DATE: {
                    this.returnType.writeInt(columnBuilder, DateUtils.parseDateExpressionToInt((String)stringValue).intValue());
                    break;
                }
                case INT64: {
                    this.returnType.writeLong(columnBuilder, Long.parseLong(stringValue));
                    break;
                }
                case TIMESTAMP: {
                    this.returnType.writeLong(columnBuilder, DateTimeUtils.convertDatetimeStrToLong(stringValue, this.zoneId));
                    break;
                }
                case FLOAT: {
                    this.returnType.writeFloat(columnBuilder, CastFunctionHelper.castTextToFloat(stringValue));
                    break;
                }
                case DOUBLE: {
                    this.returnType.writeDouble(columnBuilder, CastFunctionHelper.castTextToDouble(stringValue));
                    break;
                }
                case BOOLEAN: {
                    this.returnType.writeBoolean(columnBuilder, CastFunctionHelper.castTextToBoolean(stringValue));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.returnType.writeBinary(columnBuilder, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported target dataType: %s", this.returnType.getTypeEnum()));
                }
            }
        }
        catch (NumberFormatException | DateTimeParseException e) {
            throw new SemanticException(String.format("Cannot cast %s to %s type", stringValue, this.returnType.getDisplayName()));
        }
    }
}

