/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TAINodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ainode.AINodeClient;
import org.apache.iotdb.commons.client.ainode.AINodeClientManager;
import org.apache.iotdb.commons.exception.ainode.LoadModelException;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.model.ModelStatus;
import org.apache.iotdb.commons.model.exception.ModelManagementException;
import org.apache.iotdb.confignode.consensus.request.write.model.CreateModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelInfoPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.model.CreateModelState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateModelProcedure
extends AbstractNodeProcedure<CreateModelState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateModelProcedure.class);
    private static final int RETRY_THRESHOLD = 0;
    private String modelName;
    private String uri;
    private ModelInformation modelInformation = null;
    private List<Integer> aiNodeIds;
    private String loadErrorMsg = "";

    public CreateModelProcedure() {
    }

    public CreateModelProcedure(String modelName, String uri) {
        this.modelName = modelName;
        this.uri = uri;
        this.aiNodeIds = new ArrayList<Integer>();
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateModelState state) {
        block8: {
            if (this.modelName == null || this.uri == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case LOADING: {
                        this.initModel(env);
                        this.loadModel(env);
                        this.setNextState(CreateModelState.ACTIVE);
                        break;
                    }
                    case ACTIVE: {
                        this.modelInformation.updateStatus(ModelStatus.ACTIVE);
                        this.updateModel(env);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unknown state during executing createModelProcedure, %s", new Object[]{state}));
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in CreateModelProcedure", (Throwable)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to create model [{}], state [{}]", new Object[]{this.modelName, state, e});
                if (this.getCycles() <= 0) break block8;
                this.modelInformation = new ModelInformation(this.modelName, ModelStatus.UNAVAILABLE);
                this.modelInformation.setAttribute(this.loadErrorMsg);
                this.updateModel(env);
                this.setFailure(new ProcedureException(String.format("Fail to create model [%s] at STATE [%s]", new Object[]{this.modelName, state})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void initModel(ConfigNodeProcedureEnv env) throws ConsensusException {
        LOGGER.info("Start to add model [{}]", (Object)this.modelName);
        ConfigManager configManager = env.getConfigManager();
        TSStatus response = configManager.getConsensusManager().write(new CreateModelPlan(this.modelName));
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ModelManagementException(String.format("Failed to add model [%s] in ModelTable on Config Nodes: %s", this.modelName, response.getMessage()));
        }
    }

    private void checkModelInformationEquals(ModelInformation receiveModelInfo) {
        if (this.modelInformation == null) {
            this.modelInformation = receiveModelInfo;
        } else if (!this.modelInformation.equals((Object)receiveModelInfo)) {
            throw new ModelManagementException(String.format("Failed to load model [%s] on AI Nodes, model information is not equal in different nodes", this.modelName));
        }
    }

    private void loadModel(ConfigNodeProcedureEnv env) {
        for (TAINodeConfiguration curNodeConfig : env.getConfigManager().getNodeManager().getRegisteredAINodes()) {
            try {
                AINodeClient client = (AINodeClient)AINodeClientManager.getInstance().borrowClient((Object)curNodeConfig.getLocation().getInternalEndPoint());
                try {
                    ModelInformation resp = client.registerModel(this.modelName, this.uri);
                    this.checkModelInformationEquals(resp);
                    this.aiNodeIds.add(curNodeConfig.getLocation().aiNodeId);
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (LoadModelException e) {
                LOGGER.warn(e.getMessage());
                this.loadErrorMsg = e.getMessage();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load model on AINode {} from ConfigNode", (Object)curNodeConfig.getLocation().getInternalEndPoint());
                this.loadErrorMsg = e.getMessage();
            }
        }
        if (this.aiNodeIds.isEmpty()) {
            throw new ModelManagementException(String.format("CREATE MODEL [%s] failed on all AINodes:[%s]", this.modelName, this.loadErrorMsg));
        }
    }

    private void updateModel(ConfigNodeProcedureEnv env) {
        LOGGER.info("Start to update model [{}]", (Object)this.modelName);
        ConfigManager configManager = env.getConfigManager();
        try {
            TSStatus response = configManager.getConsensusManager().write(new UpdateModelInfoPlan(this.modelName, this.modelInformation, this.aiNodeIds));
            if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new ModelManagementException(String.format("Failed to update model [%s] in ModelTable on Config Nodes: %s", this.modelName, response.getMessage()));
            }
        }
        catch (Exception e) {
            throw new ModelManagementException(String.format("Failed to update model [%s] in ModelTable on Config Nodes: %s", this.modelName, e.getMessage()));
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, CreateModelState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(CreateModelState state) {
        return false;
    }

    @Override
    protected CreateModelState getState(int stateId) {
        return CreateModelState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateModelState createModelState) {
        return createModelState.ordinal();
    }

    @Override
    protected CreateModelState getInitialState() {
        return CreateModelState.LOADING;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_MODEL_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.uri, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.modelName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.uri = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof CreateModelProcedure) {
            CreateModelProcedure thatProc = (CreateModelProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && Objects.equals(thatProc.modelName, this.modelName) && Objects.equals(thatProc.uri, this.uri);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.modelName, this.uri});
    }
}

