/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.iotdb.db.pipe.resource.memory.PipeDynamicMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeFixedMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.strategy.DynamicMemoryAllocationStrategy;

public class PipeModelFixedMemoryBlock
extends PipeFixedMemoryBlock {
    private final Set<PipeDynamicMemoryBlock> memoryBlocks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DynamicMemoryAllocationStrategy allocationStrategy;
    private volatile long memoryAllocatedInBytes = 0L;

    public PipeModelFixedMemoryBlock(long memoryUsageInBytes, DynamicMemoryAllocationStrategy allocationStrategy) {
        super(memoryUsageInBytes);
        this.allocationStrategy = allocationStrategy;
    }

    public synchronized PipeDynamicMemoryBlock registerPipeBatchMemoryBlock(long memorySizeInBytes) {
        PipeDynamicMemoryBlock memoryBlock = new PipeDynamicMemoryBlock(this, 0L);
        this.memoryBlocks.add(memoryBlock);
        if (memorySizeInBytes != 0L) {
            this.resetMemoryBlockSize(memoryBlock, memorySizeInBytes);
            double e = (double)this.getMemoryUsageInBytes() / (double)memorySizeInBytes;
            memoryBlock.updateMemoryEfficiency(e, e);
            return memoryBlock;
        }
        memoryBlock.updateMemoryEfficiency(0.0, 0.0);
        return memoryBlock;
    }

    @Override
    public synchronized boolean expand() {
        this.memoryBlocks.stream().sorted((a, b) -> Long.compare(b.getMemoryUsageInBytes(), a.getMemoryUsageInBytes())).forEach(PipeDynamicMemoryBlock::doExpand);
        return false;
    }

    public long getMemoryAllocatedInBytes() {
        return this.memoryAllocatedInBytes;
    }

    public synchronized Set<PipeDynamicMemoryBlock> getMemoryBlocks() {
        return this.memoryBlocks;
    }

    synchronized void releaseMemory(PipeDynamicMemoryBlock memoryBlock) {
        this.resetMemoryBlockSize(memoryBlock, 0L);
        this.memoryBlocks.remove(memoryBlock);
    }

    synchronized void dynamicallyAdjustMemory(PipeDynamicMemoryBlock block) {
        if (this.isReleased() || block.isReleased() || !this.memoryBlocks.contains(block)) {
            throw new IllegalStateException("The memory block has been released");
        }
        this.allocationStrategy.dynamicallyAdjustMemory(block);
    }

    synchronized void resetMemoryBlockSize(PipeDynamicMemoryBlock block, long memorySizeInBytes) {
        if (this.isReleased() || block.isReleased() || !this.memoryBlocks.contains(block)) {
            throw new IllegalStateException("The memory block has been released");
        }
        long diff = memorySizeInBytes - block.getMemoryUsageInBytes();
        if (this.getMemoryUsageInBytes() - this.memoryAllocatedInBytes < diff) {
            block.setMemoryUsageInBytes(block.getMemoryUsageInBytes() + this.getMemoryUsageInBytes() - this.memoryAllocatedInBytes);
            this.memoryAllocatedInBytes = this.getMemoryUsageInBytes();
            return;
        }
        this.memoryAllocatedInBytes += diff;
        block.setMemoryUsageInBytes(memorySizeInBytes);
    }

    Stream<PipeDynamicMemoryBlock> getMemoryBlocksStream() {
        if (this.isReleased()) {
            throw new IllegalStateException("The memory block has been released");
        }
        return this.memoryBlocks.stream();
    }

    @Override
    public synchronized void close() {
        this.memoryBlocks.forEach(PipeDynamicMemoryBlock::close);
        super.close();
    }
}

