/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.text.ParseException;
import java.util.Date;
import javax.inject.Singleton;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.HttpDateFormat;
import org.glassfish.jersey.server.internal.LocalizationMessages;

@Singleton
class ParamConverters {
    ParamConverters() {
    }

    @Singleton
    public static class AggregatedProvider
    implements ParamConverterProvider {
        private final ParamConverterProvider[] providers;

        public AggregatedProvider(@Context ServiceLocator locator) {
            this.providers = new ParamConverterProvider[]{(ParamConverterProvider)locator.createAndInitialize(DateProvider.class), (ParamConverterProvider)locator.createAndInitialize(TypeFromStringEnum.class), (ParamConverterProvider)locator.createAndInitialize(TypeValueOf.class), (ParamConverterProvider)locator.createAndInitialize(CharacterProvider.class), (ParamConverterProvider)locator.createAndInitialize(TypeFromString.class), (ParamConverterProvider)locator.createAndInitialize(StringConstructor.class)};
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            for (ParamConverterProvider p : this.providers) {
                ParamConverter reader = p.getConverter(rawType, genericType, annotations);
                if (reader == null) continue;
                return reader;
            }
            return null;
        }
    }

    @Singleton
    public static class DateProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            return rawType != Date.class ? null : new ParamConverter<T>(){

                public T fromString(String value) {
                    if (value == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    try {
                        return rawType.cast(HttpDateFormat.readDate((String)value));
                    }
                    catch (ParseException ex) {
                        throw new ExtractorException((Throwable)ex);
                    }
                }

                public String toString(T value) throws IllegalArgumentException {
                    if (value == null) {
                        throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                    }
                    return value.toString();
                }
            };
        }
    }

    @Singleton
    public static class CharacterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType.equals(Character.class)) {
                return new ParamConverter<T>(){

                    public T fromString(String value) {
                        if (value == null || value.isEmpty()) {
                            return null;
                        }
                        if (value.length() == 1) {
                            return rawType.cast(Character.valueOf(value.charAt(0)));
                        }
                        throw new ExtractorException(LocalizationMessages.ERROR_PARAMETER_INVALID_CHAR_VALUE(value));
                    }

                    public String toString(T value) {
                        if (value == null) {
                            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
                        }
                        return value.toString();
                    }
                };
            }
            return null;
        }
    }

    @Singleton
    public static class TypeFromStringEnum
    extends TypeFromString {
        @Override
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            return !Enum.class.isAssignableFrom(rawType) ? null : super.getConverter(rawType, genericType, annotations);
        }
    }

    @Singleton
    public static class TypeFromString
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Method fromStringMethod = (Method)AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA(rawType));
            return fromStringMethod == null ? null : new AbstractStringReader<T>(){

                @Override
                public T _fromString(String value) throws Exception {
                    return rawType.cast(fromStringMethod.invoke(null, value));
                }
            };
        }
    }

    @Singleton
    public static class TypeValueOf
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Method valueOf = (Method)AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA(rawType));
            return valueOf == null ? null : new AbstractStringReader<T>(){

                @Override
                public T _fromString(String value) throws Exception {
                    return rawType.cast(valueOf.invoke(null, value));
                }
            };
        }
    }

    @Singleton
    public static class StringConstructor
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
            final Constructor constructor = (Constructor)AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(rawType));
            return constructor == null ? null : new AbstractStringReader<T>(){

                @Override
                protected T _fromString(String value) throws Exception {
                    return rawType.cast(constructor.newInstance(value));
                }
            };
        }
    }

    private static abstract class AbstractStringReader<T>
    implements ParamConverter<T> {
        private AbstractStringReader() {
        }

        public T fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
            }
            try {
                return this._fromString(value);
            }
            catch (InvocationTargetException ex) {
                if (value.isEmpty()) {
                    return null;
                }
                Throwable cause = ex.getCause();
                if (cause instanceof WebApplicationException) {
                    throw (WebApplicationException)cause;
                }
                throw new ExtractorException(cause);
            }
            catch (Exception ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }

        protected abstract T _fromString(String var1) throws Exception;

        public String toString(T value) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
            }
            return value.toString();
        }
    }
}

