/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TypeInferenceUtils {
    private static TSDataType booleanStringInferType = IoTDBDescriptor.getInstance().getConfig().getBooleanStringInferType();
    private static TSDataType integerStringInferType = IoTDBDescriptor.getInstance().getConfig().getIntegerStringInferType();
    private static TSDataType longStringInferType = IoTDBDescriptor.getInstance().getConfig().getLongStringInferType();
    private static TSDataType floatingStringInferType = IoTDBDescriptor.getInstance().getConfig().getFloatingStringInferType();
    private static TSDataType nanStringInferType = IoTDBDescriptor.getInstance().getConfig().getNanStringInferType();

    private TypeInferenceUtils() {
    }

    static boolean isNumber(String s) {
        if (s == null || s.equals("NaN")) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private static boolean isConvertFloatPrecisionLack(String s) {
        try {
            return Long.parseLong(s) > 0x2000000L;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static TSDataType getPredictedDataType(Object value, boolean inferType) {
        if (inferType) {
            String strValue = value.toString();
            if (TypeInferenceUtils.isBoolean(strValue)) {
                return booleanStringInferType;
            }
            if (TypeInferenceUtils.isNumber(strValue)) {
                if (!strValue.contains(".")) {
                    if (TypeInferenceUtils.isConvertFloatPrecisionLack(StringUtils.trim((String)strValue))) {
                        return longStringInferType;
                    }
                    return integerStringInferType;
                }
                return floatingStringInferType;
            }
            if ("null".equals(strValue) || "NULL".equals(strValue)) {
                return null;
            }
            if ("NaN".equals(strValue)) {
                return nanStringInferType;
            }
            return TSDataType.TEXT;
        }
        if (value instanceof Boolean) {
            return TSDataType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return TSDataType.INT32;
        }
        if (value instanceof Long) {
            return TSDataType.INT64;
        }
        if (value instanceof Float) {
            return TSDataType.FLOAT;
        }
        if (value instanceof Double) {
            return TSDataType.DOUBLE;
        }
        return TSDataType.TEXT;
    }

    public static TSDataType getAggrDataType(String aggrFuncName, TSDataType dataType) {
        if (aggrFuncName == null) {
            throw new IllegalArgumentException("AggregateFunction Name must not be null");
        }
        switch (aggrFuncName.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": {
                return TSDataType.INT64;
            }
            case "min_value": 
            case "last_value": 
            case "first_value": 
            case "max_value": 
            case "extreme": {
                return dataType;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggrFuncName);
    }
}

