/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.api.customizer.strategy;

import java.time.ZoneId;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;

public class SlidingTimeWindowAccessStrategy
implements AccessStrategy {
    private final boolean inputInString;
    private String timeIntervalString;
    private String slidingStepString;
    private String displayWindowBeginString;
    private String displayWindowEndString;
    private long timeInterval;
    private long slidingStep;
    private long displayWindowBegin;
    private long displayWindowEnd;
    private ZoneId zoneId;

    public SlidingTimeWindowAccessStrategy(String timeIntervalString, String slidingStepString, String displayWindowBeginString, String displayWindowEndString) {
        this.inputInString = true;
        this.timeIntervalString = timeIntervalString;
        this.slidingStepString = slidingStepString;
        this.displayWindowBeginString = displayWindowBeginString;
        this.displayWindowEndString = displayWindowEndString;
    }

    public SlidingTimeWindowAccessStrategy(String timeIntervalString, String slidingStepString) {
        this.inputInString = true;
        this.timeIntervalString = timeIntervalString;
        this.slidingStepString = slidingStepString;
    }

    public SlidingTimeWindowAccessStrategy(String timeIntervalString) {
        this.inputInString = true;
        this.timeIntervalString = timeIntervalString;
    }

    public SlidingTimeWindowAccessStrategy(long timeInterval, long slidingStep, long displayWindowBegin, long displayWindowEnd) {
        this.inputInString = false;
        this.timeInterval = timeInterval;
        this.slidingStep = slidingStep;
        this.displayWindowBegin = displayWindowBegin;
        this.displayWindowEnd = displayWindowEnd;
    }

    public SlidingTimeWindowAccessStrategy(long timeInterval, long slidingStep) {
        this.inputInString = false;
        this.timeInterval = timeInterval;
        this.slidingStep = slidingStep;
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
    }

    public SlidingTimeWindowAccessStrategy(long timeInterval) {
        this.inputInString = false;
        this.timeInterval = timeInterval;
        this.slidingStep = timeInterval;
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
    }

    @Override
    public void check() throws QueryProcessException {
        if (this.inputInString) {
            this.parseStringParameters();
        }
        if (this.timeInterval <= 0L) {
            throw new QueryProcessException(String.format("Parameter timeInterval(%d) should be positive.", this.timeInterval));
        }
        if (this.slidingStep <= 0L) {
            throw new QueryProcessException(String.format("Parameter slidingStep(%d) should be positive.", this.slidingStep));
        }
        if (this.displayWindowEnd < this.displayWindowBegin) {
            throw new QueryProcessException(String.format("displayWindowEnd(%d) < displayWindowBegin(%d)", this.displayWindowEnd, this.displayWindowBegin));
        }
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }

    public long getDisplayWindowBegin() {
        return this.displayWindowBegin;
    }

    public long getDisplayWindowEnd() {
        return this.displayWindowEnd;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public AccessStrategy.AccessStrategyType getAccessStrategyType() {
        return AccessStrategy.AccessStrategyType.SLIDING_TIME_WINDOW;
    }

    private void parseStringParameters() throws QueryProcessException {
        this.timeInterval = DateTimeUtils.convertDurationStrToLong(this.timeIntervalString);
        this.slidingStep = this.slidingStepString == null ? this.timeInterval : DateTimeUtils.convertDurationStrToLong(this.slidingStepString);
        this.displayWindowBegin = this.displayWindowBeginString == null ? Long.MIN_VALUE : DateTimeUtils.convertDatetimeStrToLong(this.displayWindowBeginString, this.zoneId);
        this.displayWindowEnd = this.displayWindowEndString == null ? Long.MAX_VALUE : DateTimeUtils.convertDatetimeStrToLong(this.displayWindowEndString, this.zoneId);
    }
}

