/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerMemoryAssigner;
import org.apache.iotdb.db.query.udf.core.layer.RawQueryInputLayer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class Expression {
    private String expressionStringCache;
    protected Boolean isConstantOperandCache = null;

    public boolean isPlainAggregationFunctionExpression() {
        return false;
    }

    public boolean isUserDefinedAggregationFunctionExpression() {
        return false;
    }

    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return false;
    }

    public abstract void concat(List<PartialPath> var1, List<Expression> var2);

    public abstract void removeWildcards(WildcardsRemover var1, List<Expression> var2) throws LogicalOptimizeException;

    public abstract void collectPaths(Set<PartialPath> var1);

    public abstract void constructUdfExecutors(Map<String, UDTFExecutor> var1, ZoneId var2);

    public abstract void updateStatisticsForMemoryAssigner(LayerMemoryAssigner var1);

    public abstract IntermediateLayer constructIntermediateLayer(long var1, UDTFPlan var3, RawQueryInputLayer var4, Map<Expression, IntermediateLayer> var5, Map<Expression, TSDataType> var6, LayerMemoryAssigner var7) throws QueryProcessException, IOException;

    protected abstract boolean isConstantOperandInternal();

    public abstract List<Expression> getExpressions();

    public final boolean isConstantOperand() {
        if (this.isConstantOperandCache == null) {
            this.isConstantOperandCache = this.isConstantOperandInternal();
        }
        return this.isConstantOperandCache;
    }

    protected abstract String getExpressionStringInternal();

    public final String getExpressionString() {
        if (this.expressionStringCache == null) {
            this.expressionStringCache = this.getExpressionStringInternal();
        }
        return this.expressionStringCache;
    }

    public final int hashCode() {
        return this.getExpressionString().hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        return this.getExpressionString().equals(((Expression)o).getExpressionString());
    }

    public final String toString() {
        return this.getExpressionString();
    }

    public final Iterator<Expression> iterator() {
        return new ExpressionIterator(this);
    }

    private static class ExpressionIterator
    implements Iterator<Expression> {
        private final Deque<Expression> queue = new LinkedList<Expression>();

        public ExpressionIterator(Expression expression) {
            this.queue.add(expression);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Expression next() {
            if (!this.hasNext()) {
                return null;
            }
            Expression current = this.queue.pop();
            if (current != null) {
                for (Expression subExp : current.getExpressions()) {
                    this.queue.push(subExp);
                }
            }
            return current;
        }
    }
}

