/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage.serializable;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LogManagerMeta {
    private long commitLogTerm = -1L;
    private long commitLogIndex = -1L;
    private long lastLogIndex = -1L;
    private long lastLogTerm = -1L;
    private long maxHaveAppliedCommitIndex = -1L;

    public static LogManagerMeta deserialize(ByteBuffer buffer) {
        LogManagerMeta res = new LogManagerMeta();
        res.commitLogTerm = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        res.commitLogIndex = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        res.lastLogIndex = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        res.lastLogTerm = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        res.maxHaveAppliedCommitIndex = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        return res;
    }

    public long getCommitLogIndex() {
        return this.commitLogIndex;
    }

    void setCommitLogIndex(long commitLogIndex) {
        this.commitLogIndex = commitLogIndex;
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(40);
        byteBuffer.putLong(this.commitLogTerm);
        byteBuffer.putLong(this.commitLogIndex);
        byteBuffer.putLong(this.lastLogIndex);
        byteBuffer.putLong(this.lastLogTerm);
        byteBuffer.putLong(this.maxHaveAppliedCommitIndex);
        byteBuffer.flip();
        return byteBuffer;
    }

    public String toString() {
        return "LogManagerMeta{ commitLogTerm=" + this.commitLogTerm + ", commitLogIndex=" + this.commitLogIndex + ", lastLogIndex=" + this.lastLogIndex + ", lastLogTerm=" + this.lastLogTerm + ", maxHaveAppliedCommitIndex=" + this.maxHaveAppliedCommitIndex + "}";
    }

    public long getLastLogIndex() {
        return this.lastLogIndex;
    }

    public void setLastLogIndex(long lastLogIndex) {
        this.lastLogIndex = lastLogIndex;
    }

    public long getLastLogTerm() {
        return this.lastLogTerm;
    }

    public void setLastLogTerm(long lastLogTerm) {
        this.lastLogTerm = lastLogTerm;
    }

    public void setCommitLogTerm(long commitLogTerm) {
        this.commitLogTerm = commitLogTerm;
    }

    public long getMaxHaveAppliedCommitIndex() {
        return this.maxHaveAppliedCommitIndex;
    }

    public void setMaxHaveAppliedCommitIndex(long maxHaveAppliedCommitIndex) {
        this.maxHaveAppliedCommitIndex = maxHaveAppliedCommitIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogManagerMeta)) {
            return false;
        }
        LogManagerMeta that = (LogManagerMeta)o;
        return new EqualsBuilder().append(this.commitLogIndex, that.commitLogIndex).append(this.lastLogIndex, that.lastLogIndex).append(this.lastLogTerm, that.lastLogTerm).append(this.commitLogTerm, that.commitLogTerm).append(this.maxHaveAppliedCommitIndex, that.maxHaveAppliedCommitIndex).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.commitLogIndex).append(this.lastLogIndex).append(this.lastLogTerm).append(this.commitLogTerm).append(this.maxHaveAppliedCommitIndex).toHashCode();
    }
}

