/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.AsyncTaskType;
import org.apache.polaris.core.entity.TaskEntity;
import org.apache.polaris.service.task.FileCleanupTaskHandler;
import org.apache.polaris.service.task.TaskFileIOSupplier;
import org.apache.polaris.service.task.TaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchFileCleanupTaskHandler
extends FileCleanupTaskHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchFileCleanupTaskHandler.class);

    public BatchFileCleanupTaskHandler(TaskFileIOSupplier fileIOSupplier, ExecutorService executorService) {
        super(fileIOSupplier, executorService);
    }

    @Override
    public boolean canHandleTask(TaskEntity task) {
        return task.getTaskType() == AsyncTaskType.BATCH_FILE_CLEANUP;
    }

    @Override
    public boolean handleTask(TaskEntity task, CallContext callContext) {
        BatchFileCleanupTask cleanupTask = (BatchFileCleanupTask)task.readData(BatchFileCleanupTask.class);
        TableIdentifier tableId = cleanupTask.tableId();
        List<String> batchFiles = cleanupTask.batchFiles();
        try (FileIO authorizedFileIO = this.fileIOSupplier.apply(task, tableId);){
            List<String> validFiles = batchFiles.stream().filter(file -> TaskUtils.exists(file, authorizedFileIO)).toList();
            if (validFiles.isEmpty()) {
                LOGGER.atWarn().addKeyValue("batchFiles", (Object)batchFiles.toString()).addKeyValue("tableId", (Object)tableId).log("File batch cleanup task scheduled, but none of the files in batch exists");
                boolean bl = true;
                return bl;
            }
            if (validFiles.size() < batchFiles.size()) {
                List<String> missingFiles = batchFiles.stream().filter(file -> !TaskUtils.exists(file, authorizedFileIO)).toList();
                LOGGER.atWarn().addKeyValue("batchFiles", (Object)batchFiles.toString()).addKeyValue("missingFiles", (Object)missingFiles.toString()).addKeyValue("tableId", (Object)tableId).log("File batch cleanup task scheduled, but {} files in the batch are missing", (Object)missingFiles.size());
            }
            List<CompletableFuture> deleteFutures = validFiles.stream().map(file -> super.tryDelete(tableId, authorizedFileIO, null, (String)file, null, 1)).toList();
            try {
                CompletableFuture<Void> allDeletes = CompletableFuture.allOf(deleteFutures.toArray(new CompletableFuture[0]));
                allDeletes.join();
            }
            catch (Exception e) {
                LOGGER.error("Exception detected during batch files deletion", (Throwable)e);
                boolean bl = false;
                if (authorizedFileIO != null) {
                    authorizedFileIO.close();
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public record BatchFileCleanupTask(TableIdentifier tableId, List<String> batchFiles) {
    }
}

