/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.encryption.KeyMetadataDecoder;
import org.apache.iceberg.encryption.KeyMetadataEncoder;
import org.apache.iceberg.encryption.NativeEncryptionKeyMetadata;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class StandardKeyMetadata
implements NativeEncryptionKeyMetadata,
IndexedRecord {
    private static final byte V1 = 1;
    private static final Schema SCHEMA_V1 = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"encryption_key", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)1, (String)"aad_prefix", (Type)Types.BinaryType.get())});
    private static final org.apache.avro.Schema AVRO_SCHEMA_V1 = AvroSchemaUtil.convert(SCHEMA_V1, StandardKeyMetadata.class.getCanonicalName());
    private static final Map<Byte, Schema> SCHEMA_VERSIONS = ImmutableMap.of((Object)1, (Object)SCHEMA_V1);
    private static final Map<Byte, org.apache.avro.Schema> AVRO_SCHEMA_VERSIONS = ImmutableMap.of((Object)1, (Object)AVRO_SCHEMA_V1);
    private static final KeyMetadataEncoder KEY_METADATA_ENCODER = new KeyMetadataEncoder(1);
    private static final KeyMetadataDecoder KEY_METADATA_DECODER = new KeyMetadataDecoder(1);
    private ByteBuffer encryptionKey;
    private ByteBuffer aadPrefix;
    private org.apache.avro.Schema avroSchema;

    StandardKeyMetadata() {
    }

    StandardKeyMetadata(byte[] key, byte[] aad) {
        this.encryptionKey = ByteBuffer.wrap(key);
        this.aadPrefix = ByteBuffer.wrap(aad);
    }

    private StandardKeyMetadata(ByteBuffer encryptionKey, ByteBuffer aadPrefix) {
        this.encryptionKey = encryptionKey;
        this.aadPrefix = aadPrefix;
        this.avroSchema = AVRO_SCHEMA_V1;
    }

    static Map<Byte, Schema> supportedSchemaVersions() {
        return SCHEMA_VERSIONS;
    }

    static Map<Byte, org.apache.avro.Schema> supportedAvroSchemaVersions() {
        return AVRO_SCHEMA_VERSIONS;
    }

    @Override
    public ByteBuffer encryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public ByteBuffer aadPrefix() {
        return this.aadPrefix;
    }

    static StandardKeyMetadata castOrParse(EncryptionKeyMetadata keyMetadata) {
        if (keyMetadata instanceof StandardKeyMetadata) {
            return (StandardKeyMetadata)keyMetadata;
        }
        ByteBuffer kmBuffer = keyMetadata.buffer();
        if (kmBuffer == null) {
            throw new IllegalStateException("Null key metadata buffer");
        }
        return StandardKeyMetadata.parse(kmBuffer);
    }

    static StandardKeyMetadata parse(ByteBuffer buffer) {
        try {
            return (StandardKeyMetadata)KEY_METADATA_DECODER.decode(buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse envelope encryption metadata", e);
        }
    }

    public ByteBuffer buffer() {
        try {
            return KEY_METADATA_ENCODER.encode(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize envelope key metadata", e);
        }
    }

    public EncryptionKeyMetadata copy() {
        return new StandardKeyMetadata(this.encryptionKey(), this.aadPrefix());
    }

    public void put(int i, Object v) {
        switch (i) {
            case 0: {
                this.encryptionKey = (ByteBuffer)v;
                return;
            }
            case 1: {
                this.aadPrefix = (ByteBuffer)v;
                return;
            }
        }
    }

    public Object get(int i) {
        switch (i) {
            case 0: {
                return this.encryptionKey;
            }
            case 1: {
                return this.aadPrefix;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }

    public org.apache.avro.Schema getSchema() {
        return this.avroSchema;
    }
}

