/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

public class BlockingTaskRunner<T>
implements OidcRequestContext<T> {
    private final BlockingSecurityExecutor blockingExecutor;

    public BlockingTaskRunner() {
        this.blockingExecutor = new BlockingSecurityExecutor(){
            private volatile BlockingSecurityExecutor delegate = null;

            public <O> Uni<O> executeBlocking(Supplier<? extends O> supplier) {
                if (this.delegate == null) {
                    this.delegate = (BlockingSecurityExecutor)Arc.container().select(BlockingSecurityExecutor.class, new Annotation[0]).get();
                }
                return this.delegate.executeBlocking(supplier);
            }
        };
    }

    public BlockingTaskRunner(BlockingSecurityExecutor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    @Override
    public Uni<T> runBlocking(Supplier<T> function) {
        return this.blockingExecutor.executeBlocking(function);
    }
}

