/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static final Unsafe unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException e) {
                IllegalAccessError error = new IllegalAccessError(e.getMessage());
                error.setStackTrace(e.getStackTrace());
                throw error;
            }
            catch (NoSuchFieldException e) {
                NoSuchFieldError error = new NoSuchFieldError(e.getMessage());
                error.setStackTrace(e.getStackTrace());
                throw error;
            }
        }
    });
    private static final long contextClassLoaderOffs;

    private JDKSpecific() {
    }

    static void setThreadContextClassLoader(Thread thread, ClassLoader classLoader) {
        unsafe.putObject(thread, contextClassLoaderOffs, classLoader);
    }

    static ClassLoader getThreadContextClassLoader(Thread thread) {
        return (ClassLoader)unsafe.getObject(thread, contextClassLoaderOffs);
    }

    static {
        try {
            contextClassLoaderOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("contextClassLoader"));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class ThreadAccess {
        private static final long threadLocalMapOffs;
        private static final long inheritableThreadLocalMapOffs;

        ThreadAccess() {
        }

        static void clearThreadLocals() {
            Thread thread = Thread.currentThread();
            unsafe.putObject(thread, threadLocalMapOffs, null);
            unsafe.putObject(thread, inheritableThreadLocalMapOffs, null);
        }

        static {
            try {
                threadLocalMapOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
                inheritableThreadLocalMapOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
            }
            catch (NoSuchFieldException e) {
                NoSuchFieldError error = new NoSuchFieldError(e.getMessage());
                error.setStackTrace(e.getStackTrace());
                throw error;
            }
        }
    }
}

