/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A Polaris principal.")
public class Principal {
    @NotNull
    @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$")
    @Size(min=1, max=256)
    private final @NotNull @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String name;
    private final String clientId;
    private final Map<String, String> properties;
    private final Long createTimestamp;
    private final Long lastUpdateTimestamp;
    private final Integer entityVersion;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The output-only OAuth clientId associated with this principal if applicable")
    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="createTimestamp")
    public Long getCreateTimestamp() {
        return this.createTimestamp;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdateTimestamp")
    public Long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    @ApiModelProperty(value="The version of the principal object used to determine if the principal metadata has changed")
    @JsonProperty(value="entityVersion")
    public Integer getEntityVersion() {
        return this.entityVersion;
    }

    @JsonCreator
    public Principal(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="createTimestamp") Long createTimestamp, @JsonProperty(value="lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value="entityVersion") Integer entityVersion) {
        this.name = name;
        this.clientId = clientId;
        this.properties = Objects.requireNonNullElse(properties, new HashMap());
        this.createTimestamp = createTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.entityVersion = entityVersion;
    }

    public Principal(String name) {
        this.name = name;
        this.clientId = null;
        this.properties = new HashMap<String, String>();
        this.createTimestamp = null;
        this.lastUpdateTimestamp = null;
        this.entityVersion = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Principal principal = (Principal)o;
        return Objects.equals(this.name, principal.name) && Objects.equals(this.clientId, principal.clientId) && Objects.equals(this.properties, principal.properties) && Objects.equals(this.createTimestamp, principal.createTimestamp) && Objects.equals(this.lastUpdateTimestamp, principal.lastUpdateTimestamp) && Objects.equals(this.entityVersion, principal.entityVersion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.clientId, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Principal {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    createTimestamp: ").append(this.toIndentedString(this.createTimestamp)).append("\n");
        sb.append("    lastUpdateTimestamp: ").append(this.toIndentedString(this.lastUpdateTimestamp)).append("\n");
        sb.append("    entityVersion: ").append(this.toIndentedString(this.entityVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String name;
        private String clientId;
        private Map<String, String> properties;
        private Long createTimestamp;
        private Long lastUpdateTimestamp;
        private Integer entityVersion;

        private Builder() {
        }

        private Builder(String name) {
            this.name = name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setCreateTimestamp(Long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public Builder setEntityVersion(Integer entityVersion) {
            this.entityVersion = entityVersion;
            return this;
        }

        public Principal build() {
            Principal inst = new Principal(this.name, this.clientId, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion);
            return inst;
        }
    }
}

