/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.api;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.faulttolerance.api.Spi;
import java.util.ServiceLoader;

@Experimental(value="first attempt at providing programmatic API")
public final class SpiAccess {
    public static Spi get() {
        return Holder.INSTANCE;
    }

    private static Spi instantiateSpi() {
        Spi bestCandidate = null;
        int bestCandidatePriority = Integer.MIN_VALUE;
        for (Spi candidate : ServiceLoader.load(Spi.class)) {
            if (!candidate.applies() || candidate.priority() <= bestCandidatePriority) continue;
            bestCandidate = candidate;
            bestCandidatePriority = candidate.priority();
        }
        if (bestCandidate == null) {
            throw new IllegalStateException("Could not find implementation of io.smallrye.faulttolerance.api.Spi, add a dependency on io.smallrye:smallrye-fault-tolerance or io.smallrye:smallrye-fault-tolerance-standalone");
        }
        return bestCandidate;
    }

    private static class Holder {
        private static final Spi INSTANCE = SpiAccess.instantiateSpi();

        private Holder() {
        }
    }
}

