/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.algorithm;

import java.util.StringJoiner;

public enum SignatureAlgorithm {
    RS256("RS256"),
    RS384("RS384"),
    RS512("RS512"),
    ES256("ES256"),
    ES384("ES384"),
    ES512("ES512"),
    EDDSA("EdDSA"),
    HS256("HS256"),
    HS384("HS384"),
    HS512("HS512"),
    PS256("PS256"),
    PS384("PS384"),
    PS512("PS512");

    private final String algorithmName;

    private SignatureAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    public static SignatureAlgorithm fromAlgorithm(String algorithmName) {
        try {
            return SignatureAlgorithm.valueOf(algorithmName.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid signature algorithm name: " + algorithmName + ", expected one of: " + SignatureAlgorithm.getValidNames(), e);
        }
    }

    private static String getValidNames() {
        StringJoiner names = new StringJoiner(", ");
        for (SignatureAlgorithm alg : SignatureAlgorithm.values()) {
            names.add(alg.getAlgorithm());
        }
        return names.toString();
    }
}

