/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.server;

import com.google.common.collect.Sets;
import io.grpc.stub.StreamObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeReporter;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.server.AgentHostStoreMessenger;
import org.apache.bifromq.basekv.server.BaseKVStoreServiceBuilder;
import org.apache.bifromq.basekv.server.MutatePipeline;
import org.apache.bifromq.basekv.server.QueryPipeline;
import org.apache.bifromq.basekv.store.IKVRangeStore;
import org.apache.bifromq.basekv.store.KVRangeStore;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.proto.BaseKVStoreServiceGrpc;
import org.apache.bifromq.basekv.store.proto.BootstrapReply;
import org.apache.bifromq.basekv.store.proto.BootstrapRequest;
import org.apache.bifromq.basekv.store.proto.ChangeReplicaConfigReply;
import org.apache.bifromq.basekv.store.proto.ChangeReplicaConfigRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeMergeReply;
import org.apache.bifromq.basekv.store.proto.KVRangeMergeRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeROReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.KVRangeRWReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRWRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeSplitReply;
import org.apache.bifromq.basekv.store.proto.KVRangeSplitRequest;
import org.apache.bifromq.basekv.store.proto.RecoverReply;
import org.apache.bifromq.basekv.store.proto.RecoverRequest;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.basekv.store.proto.TransferLeadershipReply;
import org.apache.bifromq.basekv.store.proto.TransferLeadershipRequest;
import org.apache.bifromq.basekv.store.proto.ZombieQuitReply;
import org.apache.bifromq.basekv.store.proto.ZombieQuitRequest;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.baserpc.server.UnaryResponse;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVStoreService
extends BaseKVStoreServiceGrpc.BaseKVStoreServiceImplBase {
    private final Logger log;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final IKVRangeStore kvRangeStore;
    private final IAgentHost agentHost;
    private final String clusterId;
    private final IBaseKVMetaService metaService;
    private IBaseKVLandscapeReporter landscapeReporter;

    BaseKVStoreService(BaseKVStoreServiceBuilder builder) {
        this.kvRangeStore = new KVRangeStore(builder.clusterId, builder.storeOptions, builder.coProcFactory, builder.queryExecutor, builder.tickerThreads, builder.bgTaskExecutor, builder.attributes);
        this.clusterId = builder.clusterId;
        this.agentHost = builder.agentHost;
        this.metaService = builder.serverBuilder.metaService;
        this.log = MDCLogger.getLogger(BaseKVStoreService.class, (String[])new String[]{"clusterId", this.clusterId, "storeId", this.kvRangeStore.id()});
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String storeId() {
        return this.kvRangeStore.id();
    }

    public void start() {
        this.log.debug("Starting BaseKVStore service");
        this.kvRangeStore.start(new AgentHostStoreMessenger(this.agentHost, this.clusterId, this.kvRangeStore.id()));
        this.landscapeReporter = this.metaService.landscapeReporter(this.clusterId, this.kvRangeStore.id());
        this.disposables.add(this.kvRangeStore.describe().subscribe(arg_0 -> ((IBaseKVLandscapeReporter)this.landscapeReporter).report(arg_0)));
        this.disposables.add(this.landscapeReporter.refreshSignal().subscribe(ts -> this.landscapeReporter.report((KVRangeStoreDescriptor)this.kvRangeStore.describe().blockingFirst())));
        this.log.debug("BaseKVStore service started");
    }

    public void stop() {
        this.log.debug("Stopping BaseKVStore service");
        this.landscapeReporter.stop();
        this.disposables.dispose();
        this.kvRangeStore.stop();
        this.log.debug("BaseKVStore service stopped");
    }

    public void bootstrap(BootstrapRequest request, StreamObserver<BootstrapReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.bootstrap(request.getKvRangeId(), request.getBoundary()).handle((success, e) -> {
            if (e != null) {
                this.log.error("Failed to bootstrap KVRange: rangeId={}, boundary={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)request.getKvRangeId()), request.getBoundary(), e});
                return BootstrapReply.newBuilder().setReqId(request.getReqId()).setResult(BootstrapReply.Result.Error).build();
            }
            if (success.booleanValue()) {
                return BootstrapReply.newBuilder().setReqId(request.getReqId()).setResult(BootstrapReply.Result.Ok).build();
            }
            return BootstrapReply.newBuilder().setReqId(request.getReqId()).setResult(BootstrapReply.Result.Exists).build();
        }), responseObserver);
    }

    public void recover(RecoverRequest request, StreamObserver<RecoverReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.recover(request.getKvRangeId()).thenApply(result -> RecoverReply.newBuilder().setReqId(request.getReqId()).setResult(RecoverReply.Result.Ok).build()).exceptionally(e -> RecoverReply.newBuilder().setReqId(request.getReqId()).setResult(e instanceof KVRangeStoreException ? RecoverReply.Result.NotFound : RecoverReply.Result.Error).build()).handle((v, e) -> RecoverReply.newBuilder().setReqId(request.getReqId()).build()), responseObserver);
    }

    public void zombieQuit(ZombieQuitRequest request, StreamObserver<ZombieQuitReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.quit(request.getKvRangeId()).thenApply(result -> ZombieQuitReply.newBuilder().setReqId(request.getReqId()).setResult(ZombieQuitReply.Result.Ok).setQuit(result.booleanValue()).build()).exceptionally(e -> ZombieQuitReply.newBuilder().setReqId(request.getReqId()).setResult(e instanceof KVRangeStoreException ? ZombieQuitReply.Result.NotFound : ZombieQuitReply.Result.Error).build()).handle((v, e) -> ZombieQuitReply.newBuilder().setReqId(request.getReqId()).build()), responseObserver);
    }

    public void transferLeadership(TransferLeadershipRequest request, StreamObserver<TransferLeadershipReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.transferLeadership(request.getVer(), request.getKvRangeId(), request.getNewLeaderStore()).thenApply(result -> TransferLeadershipReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).build()).exceptionally(CompletableFutureUtil.unwrap(e -> {
            TransferLeadershipReply.Builder replyBuilder = TransferLeadershipReply.newBuilder().setReqId(request.getReqId()).setCode(this.convertKVRangeException((Throwable)e));
            if (e instanceof KVRangeException.BadVersion) {
                KVRangeException.BadVersion badVersion = (KVRangeException.BadVersion)e;
                if (badVersion.latest != null) {
                    replyBuilder.setLatest(badVersion.latest);
                }
            }
            if (e instanceof KVRangeException.TryLater) {
                KVRangeException.TryLater tryLater = (KVRangeException.TryLater)e;
                if (tryLater.latest != null) {
                    replyBuilder.setLatest(tryLater.latest);
                }
            }
            return replyBuilder.build();
        })), responseObserver);
    }

    public void changeReplicaConfig(ChangeReplicaConfigRequest request, StreamObserver<ChangeReplicaConfigReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.changeReplicaConfig(request.getVer(), request.getKvRangeId(), Sets.newHashSet((Iterable)request.getNewVotersList()), Sets.newHashSet((Iterable)request.getNewLearnersList())).thenApply(result -> ChangeReplicaConfigReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).build()).exceptionally(CompletableFutureUtil.unwrap(e -> {
            ChangeReplicaConfigReply.Builder replyBuilder = ChangeReplicaConfigReply.newBuilder().setReqId(request.getReqId()).setCode(this.convertKVRangeException((Throwable)e));
            if (e instanceof KVRangeException.BadVersion) {
                KVRangeException.BadVersion badVersion = (KVRangeException.BadVersion)e;
                if (badVersion.latest != null) {
                    replyBuilder.setLatest(badVersion.latest);
                }
            }
            if (e instanceof KVRangeException.TryLater) {
                KVRangeException.TryLater tryLater = (KVRangeException.TryLater)e;
                if (tryLater.latest != null) {
                    replyBuilder.setLatest(tryLater.latest);
                }
            }
            return replyBuilder.build();
        })), responseObserver);
    }

    public void split(KVRangeSplitRequest request, StreamObserver<KVRangeSplitReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.split(request.getVer(), request.getKvRangeId(), request.getSplitKey()).thenApply(result -> KVRangeSplitReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).build()).exceptionally(CompletableFutureUtil.unwrap(e -> {
            KVRangeSplitReply.Builder replyBuilder = KVRangeSplitReply.newBuilder().setReqId(request.getReqId()).setCode(this.convertKVRangeException((Throwable)e));
            if (e instanceof KVRangeException.BadVersion) {
                KVRangeException.BadVersion badVersion = (KVRangeException.BadVersion)e;
                if (badVersion.latest != null) {
                    replyBuilder.setLatest(badVersion.latest);
                }
            }
            if (e instanceof KVRangeException.TryLater) {
                KVRangeException.TryLater tryLater = (KVRangeException.TryLater)e;
                if (tryLater.latest != null) {
                    replyBuilder.setLatest(tryLater.latest);
                }
            }
            return replyBuilder.build();
        })), responseObserver);
    }

    public void merge(KVRangeMergeRequest request, StreamObserver<KVRangeMergeReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.kvRangeStore.merge(request.getVer(), request.getMergerId(), request.getMergeeId(), Sets.newHashSet((Iterable)request.getMergeeVotersList())).thenApply(result -> KVRangeMergeReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).build()).exceptionally(CompletableFutureUtil.unwrap(e -> {
            KVRangeMergeReply.Builder replyBuilder = KVRangeMergeReply.newBuilder().setReqId(request.getReqId()).setCode(this.convertKVRangeException((Throwable)e));
            if (e instanceof KVRangeException.BadVersion) {
                KVRangeException.BadVersion badVersion = (KVRangeException.BadVersion)e;
                if (badVersion.latest != null) {
                    replyBuilder.setLatest(badVersion.latest);
                }
            }
            if (e instanceof KVRangeException.TryLater) {
                KVRangeException.TryLater tryLater = (KVRangeException.TryLater)e;
                if (tryLater.latest != null) {
                    replyBuilder.setLatest(tryLater.latest);
                }
            }
            return replyBuilder.build();
        })), responseObserver);
    }

    public StreamObserver<KVRangeRWRequest> execute(StreamObserver<KVRangeRWReply> responseObserver) {
        return new MutatePipeline(this.kvRangeStore, responseObserver);
    }

    public StreamObserver<KVRangeRORequest> query(StreamObserver<KVRangeROReply> responseObserver) {
        return new QueryPipeline(this.kvRangeStore, false, responseObserver);
    }

    public StreamObserver<KVRangeRORequest> linearizedQuery(StreamObserver<KVRangeROReply> responseObserver) {
        return new QueryPipeline(this.kvRangeStore, true, responseObserver);
    }

    private ReplyCode convertKVRangeException(Throwable e) {
        if (e instanceof KVRangeStoreException.KVRangeNotFoundException || e instanceof KVRangeException.BadVersion) {
            return ReplyCode.BadVersion;
        }
        if (e instanceof KVRangeException.TryLater) {
            return ReplyCode.TryLater;
        }
        if (e instanceof KVRangeException.BadRequest) {
            return ReplyCode.BadRequest;
        }
        this.log.error("Internal Error", e);
        return ReplyCode.InternalError;
    }

    @Generated
    public BaseKVStoreService landscapeReporter(IBaseKVLandscapeReporter landscapeReporter) {
        this.landscapeReporter = landscapeReporter;
        return this;
    }
}

