/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.AbstractBalancerStateProposerHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposer;

@Path(value="/store/balancer/rules")
final class SetLoadRulesHandler
extends AbstractBalancerStateProposerHandler
implements IHTTPRequestHandler {
    SetLoadRulesHandler(IBaseKVMetaService metaService) {
        super(metaService);
    }

    @Override
    @PUT
    @Operation(summary="Set the expected load rules of a store balancer")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="store_name", in=ParameterIn.HEADER, required=true, description="the store name", schema=@Schema(implementation=String.class)), @Parameter(name="balancer_factory_class", in=ParameterIn.HEADER, required=true, description="the full qualified name of balancer factory class configured for the store", schema=@Schema(implementation=String.class))})
    @RequestBody(content={@Content(mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success")})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        String storeName = HeaderUtils.getHeader(Headers.HEADER_STORE_NAME, (HttpRequest)req, true);
        String balancerFactoryClass = HeaderUtils.getHeader(Headers.HEADER_BALANCER_FACTORY_CLASS, (HttpRequest)req, true);
        IBaseKVStoreBalancerStatesProposer statesProposer = (IBaseKVStoreBalancerStatesProposer)this.balancerStateProposers.get(storeName);
        if (statesProposer == null) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Store not found: " + storeName).getBytes())));
        }
        try {
            Struct loadRules = this.fromJson(req.content().toString(CharsetUtil.UTF_8));
            return statesProposer.proposeLoadRules(balancerFactoryClass, loadRules).handle(CompletableFutureUtil.unwrap((v, e) -> {
                if (e != null) {
                    if (e instanceof TimeoutException) {
                        return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER);
                    }
                    return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])e.getMessage().getBytes()));
                }
                switch (v) {
                    case ACCEPTED: {
                        return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
                    }
                }
                return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.CONFLICT, Unpooled.EMPTY_BUFFER);
            }));
        }
        catch (Throwable e2) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((byte[])e2.getMessage().getBytes())));
        }
    }

    private Struct fromJson(String json) throws IOException {
        Struct.Builder structBuilder = Struct.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)structBuilder);
        return structBuilder.build();
    }
}

