/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.resourcethrottler;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.plugin.resourcethrottler.DevOnlyResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceThrottlerManager
implements IResourceThrottler,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceThrottlerManager.class);
    private static final Logger pluginLog = LoggerFactory.getLogger((String)"plugin.manager");
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final IResourceThrottler delegate;
    private final Timer callTimer;
    private final Counter callErrorCounter;

    public ResourceThrottlerManager(String resourceThrottlerFQN, PluginManager pluginMgr) {
        Map<String, IResourceThrottler> availResourceThrottlers = pluginMgr.getExtensions(IResourceThrottler.class).stream().collect(Collectors.toMap(e -> e.getClass().getName(), e -> e));
        if (availResourceThrottlers.isEmpty()) {
            pluginLog.warn("No resource throttler plugin available, use DEV ONLY one instead");
            this.delegate = new DevOnlyResourceThrottler();
        } else if (resourceThrottlerFQN == null) {
            pluginLog.warn("Resource throttler type class not specified, use DEV ONLY one instead");
            this.delegate = new DevOnlyResourceThrottler();
        } else if (!availResourceThrottlers.containsKey(resourceThrottlerFQN)) {
            pluginLog.warn("Resource throttler type '{}' not found, use DEV ONLY one instead", (Object)resourceThrottlerFQN);
            this.delegate = new DevOnlyResourceThrottler();
        } else {
            pluginLog.info("Resource throttler loaded: {}", (Object)resourceThrottlerFQN);
            this.delegate = availResourceThrottlers.get(resourceThrottlerFQN);
        }
        this.callTimer = Timer.builder((String)"call.exec.timer").tag("method", "ResourceThrottler/hasResource").tag("type", this.delegate.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
        this.callErrorCounter = Counter.builder((String)"call.exec.fail.count").tag("method", "ResourceThrottler/hasResource").tag("type", this.delegate.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
    }

    public boolean hasResource(String tenantId, TenantResourceType type) {
        assert (!this.stopped.get());
        Timer.Sample sample = Timer.start();
        try {
            boolean isEnough = this.delegate.hasResource(tenantId, type);
            sample.stop(this.callTimer);
            return isEnough;
        }
        catch (Throwable e) {
            pluginLog.error("Resource throttler throws exception: type={}", (Object)type, (Object)e);
            this.callErrorCounter.increment();
            return true;
        }
    }

    IResourceThrottler getDelegate() {
        return this.delegate;
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            log.debug("Closing resource throttler manager");
            try {
                this.delegate.close();
            }
            catch (Throwable e) {
                pluginLog.error("Failed to close resource throttler plugin", e);
            }
            Metrics.globalRegistry.remove((Meter)this.callTimer);
            Metrics.globalRegistry.remove((Meter)this.callErrorCounter);
            log.debug("Resource throttler manager closed");
        }
    }
}

