/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.base.util;

import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import lombok.Generated;

public class RendezvousHash<K, N> {
    private final Funnel<K> keyFunnel;
    private final Funnel<N> nodeFunnel;
    private final Iterable<N> nodes;

    public N get(K key) {
        long bestScore = Long.MIN_VALUE;
        N bestNode = null;
        for (N node : this.nodes) {
            long currentScore = Hashing.murmur3_128().newHasher().putObject(key, this.keyFunnel).putObject(node, this.nodeFunnel).hash().asLong();
            if (currentScore <= bestScore) continue;
            bestScore = currentScore;
            bestNode = node;
        }
        return bestNode;
    }

    @Generated
    RendezvousHash(Funnel<K> keyFunnel, Funnel<N> nodeFunnel, Iterable<N> nodes) {
        this.keyFunnel = keyFunnel;
        this.nodeFunnel = nodeFunnel;
        this.nodes = nodes;
    }

    @Generated
    public static <K, N> RendezvousHashBuilder<K, N> builder() {
        return new RendezvousHashBuilder();
    }

    @Generated
    public static class RendezvousHashBuilder<K, N> {
        @Generated
        private Funnel<K> keyFunnel;
        @Generated
        private Funnel<N> nodeFunnel;
        @Generated
        private Iterable<N> nodes;

        @Generated
        RendezvousHashBuilder() {
        }

        @Generated
        public RendezvousHashBuilder<K, N> keyFunnel(Funnel<K> keyFunnel) {
            this.keyFunnel = keyFunnel;
            return this;
        }

        @Generated
        public RendezvousHashBuilder<K, N> nodeFunnel(Funnel<N> nodeFunnel) {
            this.nodeFunnel = nodeFunnel;
            return this;
        }

        @Generated
        public RendezvousHashBuilder<K, N> nodes(Iterable<N> nodes) {
            this.nodes = nodes;
            return this;
        }

        @Generated
        public RendezvousHash<K, N> build() {
            return new RendezvousHash<K, N>(this.keyFunnel, this.nodeFunnel, this.nodes);
        }

        @Generated
        public String toString() {
            return "RendezvousHash.RendezvousHashBuilder(keyFunnel=" + String.valueOf(this.keyFunnel) + ", nodeFunnel=" + String.valueOf(this.nodeFunnel) + ", nodes=" + String.valueOf(this.nodes) + ")";
        }
    }
}

