/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store.delay;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.inbox.store.delay.IDelayTaskRunner;
import org.apache.bifromq.inbox.store.delay.IDelayedTask;

public class DelayTaskRunner<KeyT extends Comparable<KeyT>>
implements IDelayTaskRunner<KeyT> {
    private final NavigableMap<SortKey<KeyT>, IDelayedTask<KeyT>> sortedDeadlines;
    private final Map<KeyT, Long> deadLines = new ConcurrentHashMap<KeyT, Long>();
    private final Supplier<Long> currentMillisSupplier;
    private final ScheduledExecutorService executor;
    private final RateLimiter rateLimiter;
    private long nextTriggerTS;
    private ScheduledFuture<?> triggerTask;
    private volatile boolean isShutdown;

    public DelayTaskRunner(Comparator<KeyT> comparator, Supplier<Long> currentMillisSupplier, int rateLimit) {
        this.currentMillisSupplier = currentMillisSupplier;
        this.sortedDeadlines = new TreeMap<SortKey, IDelayedTask<KeyT>>(Comparator.comparingLong(sk -> sk.deadlineTS).thenComparing(sk -> sk.key, comparator));
        this.rateLimiter = RateLimiter.create((double)rateLimit);
        this.executor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, EnvProvider.INSTANCE.newThreadFactory("delay-task-runner")), (String)"delay-task-runner", (Tag[])new Tag[0]);
    }

    @VisibleForTesting
    boolean hasTask(KeyT key) {
        return this.deadLines.containsKey(key);
    }

    @Override
    public <TaskT extends IDelayedTask<KeyT>> void schedule(KeyT key, TaskT delayedTask) {
        if (this.isShutdown) {
            return;
        }
        this.executor.submit(() -> {
            if (this.isShutdown) {
                return;
            }
            Long prevDeadlineTS = this.deadLines.remove(key);
            long now = this.currentMillisSupplier.get();
            if (prevDeadlineTS != null) {
                this.sortedDeadlines.remove(new SortKey<Comparable>((Comparable)key, prevDeadlineTS));
            }
            Duration delayInterval = delayedTask.getDelay();
            long deadlineTS = this.deadline(now, delayInterval);
            this.deadLines.put(key, deadlineTS);
            this.sortedDeadlines.put(new SortKey<Comparable>((Comparable)key, deadlineTS), delayedTask);
            Map.Entry<SortKey<KeyT>, IDelayedTask<KeyT>> firstEntry = this.sortedDeadlines.firstEntry();
            long earliestDeadline = firstEntry.getKey().deadlineTS;
            if (this.nextTriggerTS == 0L || earliestDeadline < this.nextTriggerTS) {
                if (this.triggerTask != null) {
                    this.triggerTask.cancel(true);
                }
                this.nextTriggerTS = earliestDeadline;
                this.triggerTask = this.executor.schedule(this::trigger, earliestDeadline - now, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public <TaskT extends IDelayedTask<KeyT>> void scheduleIfAbsent(KeyT key, TaskT delayedTask) {
        if (this.isShutdown) {
            return;
        }
        this.executor.submit(() -> {
            if (this.isShutdown) {
                return;
            }
            if (this.deadLines.containsKey(key)) {
                return;
            }
            Long prevDeadlineTS = this.deadLines.remove(key);
            long now = this.currentMillisSupplier.get();
            if (prevDeadlineTS != null) {
                this.sortedDeadlines.remove(new SortKey<Comparable>((Comparable)key, prevDeadlineTS));
            }
            Duration delayInterval = delayedTask.getDelay();
            long deadlineTS = this.deadline(now, delayInterval);
            this.deadLines.put(key, deadlineTS);
            this.sortedDeadlines.put(new SortKey<Comparable>((Comparable)key, deadlineTS), delayedTask);
            Map.Entry<SortKey<KeyT>, IDelayedTask<KeyT>> firstEntry = this.sortedDeadlines.firstEntry();
            long earliestDeadline = firstEntry.getKey().deadlineTS;
            if (this.nextTriggerTS == 0L || earliestDeadline < this.nextTriggerTS) {
                if (this.triggerTask != null) {
                    this.triggerTask.cancel(true);
                }
                this.nextTriggerTS = earliestDeadline;
                this.triggerTask = this.executor.schedule(this::trigger, earliestDeadline - now, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public void cancelAll(Set<KeyT> keys) {
        this.executor.submit(() -> this.executor.submit(() -> {
            boolean removed = false;
            for (Comparable key : keys) {
                Long deadline = this.deadLines.remove(key);
                if (deadline == null) continue;
                this.sortedDeadlines.remove(new SortKey<Comparable>(key, deadline));
                removed = true;
            }
            if (removed) {
                Map.Entry<SortKey<KeyT>, IDelayedTask<KeyT>> firstEntry = this.sortedDeadlines.firstEntry();
                if (firstEntry != null) {
                    long earliestDeadline = firstEntry.getKey().deadlineTS;
                    if (this.nextTriggerTS == 0L || earliestDeadline < this.nextTriggerTS) {
                        if (this.triggerTask != null) {
                            this.triggerTask.cancel(true);
                        }
                        long now = this.currentMillisSupplier.get();
                        this.nextTriggerTS = earliestDeadline;
                        this.triggerTask = this.executor.schedule(this::trigger, Math.max(earliestDeadline - now, 0L), TimeUnit.MILLISECONDS);
                    }
                } else {
                    if (this.triggerTask != null) {
                        this.triggerTask.cancel(true);
                    }
                    this.nextTriggerTS = 0L;
                    this.triggerTask = null;
                }
            }
        }));
    }

    @Override
    public void shutdown() {
        this.executor.submit(() -> {
            this.isShutdown = true;
            this.executor.shutdown();
        });
    }

    private void trigger() {
        Map.Entry<SortKey<KeyT>, IDelayedTask<KeyT>> entry;
        long now = this.currentMillisSupplier.get();
        while ((entry = this.sortedDeadlines.firstEntry()) != null && this.rateLimiter.tryAcquire()) {
            SortKey<KeyT> sortKey = entry.getKey();
            IDelayedTask delayedTask = entry.getValue();
            if (entry.getKey().deadlineTS <= now) {
                this.deadLines.remove(entry.getKey().key);
                this.sortedDeadlines.remove(entry.getKey());
                delayedTask.run(sortKey.key, this);
                continue;
            }
            this.nextTriggerTS = entry.getKey().deadlineTS;
            this.triggerTask = this.executor.schedule(this::trigger, this.nextTriggerTS - now, TimeUnit.MILLISECONDS);
            return;
        }
        if (entry != null) {
            this.nextTriggerTS = entry.getKey().deadlineTS;
            long delay = Math.max(this.nextTriggerTS - now, 1000L);
            this.triggerTask = this.executor.schedule(this::trigger, delay, TimeUnit.MILLISECONDS);
        } else {
            this.nextTriggerTS = 0L;
            this.triggerTask = null;
        }
    }

    private long deadline(long now, Duration delayInterval) {
        return delayInterval.plusMillis(now).toMillis();
    }

    private record SortKey<K extends Comparable<K>>(K key, long deadlineTS) {
    }
}

