/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.metrics;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.lang.ref.Cleaner;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;

public class KVSpaceMeters {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final Cache<MeterKey, Meter> METERS = Caffeine.newBuilder().weakValues().build();

    public static Timer getTimer(String id, IKVSpaceMetric metric, Tags tags) {
        assert (metric.meterType() == Meter.Type.TIMER);
        return (Timer)METERS.get((Object)new MeterKey(id, metric, tags), k -> new TimerWrapper(Timer.builder((String)metric.metricName()).tags((Iterable)tags).tags(new String[]{"kvspace", id}).register((MeterRegistry)Metrics.globalRegistry)));
    }

    public static Counter getCounter(String id, IKVSpaceMetric metric, Tags tags) {
        assert (metric.meterType() == Meter.Type.COUNTER);
        return (Counter)METERS.get((Object)new MeterKey(id, metric, tags), k -> new CounterWrapper(Counter.builder((String)metric.metricName()).tags((Iterable)tags).tags(new String[]{"kvspace", id}).register((MeterRegistry)Metrics.globalRegistry)));
    }

    public static <C> FunctionCounter getFunctionCounter(String id, IKVSpaceMetric metric, C ctr, ToDoubleFunction<C> supplier, Tags tags) {
        assert (metric.meterType() == Meter.Type.COUNTER && metric.isFunction());
        return (FunctionCounter)METERS.get((Object)new MeterKey(id, metric, tags), k -> new FunctionCounterWrapper(FunctionCounter.builder((String)metric.metricName(), (Object)ctr, (ToDoubleFunction)supplier).tags((Iterable)tags).tags(new String[]{"kvspace", id}).register((MeterRegistry)Metrics.globalRegistry)));
    }

    public static <C> FunctionTimer getFunctionTimer(String id, IKVSpaceMetric metric, C timedObj, ToLongFunction<C> countFunction, ToDoubleFunction<C> totalTimeFunction, TimeUnit timeUnit, Tags tags) {
        assert (metric.meterType() == Meter.Type.TIMER && metric.isFunction());
        return (FunctionTimer)METERS.get((Object)new MeterKey(id, metric, tags), k -> new FunctionTimerWrapper(FunctionTimer.builder((String)metric.metricName(), (Object)timedObj, (ToLongFunction)countFunction, (ToDoubleFunction)totalTimeFunction, (TimeUnit)timeUnit).tags((Iterable)tags).tags(new String[]{"kvspace", id}).register((MeterRegistry)Metrics.globalRegistry)));
    }

    public static Gauge getGauge(String id, IKVSpaceMetric metric, Supplier<Number> numProvider, Tags tags) {
        assert (metric.meterType() == Meter.Type.GAUGE);
        return (Gauge)METERS.get((Object)new MeterKey(id, metric, tags), k -> new GaugeWrapper(Gauge.builder((String)metric.metricName(), (Supplier)numProvider).tags((Iterable)tags).tags(new String[]{"kvspace", id}).register((MeterRegistry)Metrics.globalRegistry)));
    }

    public static DistributionSummary getSummary(String id, IKVSpaceMetric metric, Tags tags) {
        assert (metric.meterType() == Meter.Type.DISTRIBUTION_SUMMARY);
        return (DistributionSummary)METERS.get((Object)new MeterKey(id, metric, tags), k -> new SummaryWrapper(DistributionSummary.builder((String)metric.metricName()).tags((Iterable)tags).tags(new String[]{"kvspace", id}).register((MeterRegistry)Metrics.globalRegistry)));
    }

    private record MeterKey(String id, IKVSpaceMetric metric, Tags tags) {
    }

    private static final class SummaryWrapper
    implements DistributionSummary {
        private final DistributionSummary delegate;
        private final Cleaner.Cleanable cleanable;

        private SummaryWrapper(DistributionSummary delegate) {
            this.delegate = delegate;
            this.cleanable = CLEANER.register(this, new State((Meter)delegate));
        }

        public void record(double amount) {
            this.delegate.record(amount);
        }

        public long count() {
            return this.delegate.count();
        }

        public double totalAmount() {
            return this.delegate.totalAmount();
        }

        public double max() {
            return this.delegate.max();
        }

        public HistogramSnapshot takeSnapshot() {
            return this.delegate.takeSnapshot();
        }

        public Meter.Id getId() {
            return this.delegate.getId();
        }

        public void close() {
            this.delegate.close();
            this.cleanable.clean();
        }
    }

    private static final class GaugeWrapper
    implements Gauge {
        private final Gauge delegate;
        private final Cleaner.Cleanable cleanable;

        private GaugeWrapper(Gauge delegate) {
            this.delegate = delegate;
            this.cleanable = CLEANER.register(this, new State((Meter)delegate));
        }

        public Meter.Id getId() {
            return this.delegate.getId();
        }

        public void close() {
            this.delegate.close();
            this.cleanable.clean();
        }

        public double value() {
            return this.delegate.value();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            GaugeWrapper that = (GaugeWrapper)obj;
            return Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public String toString() {
            return "GaugeWrapper[delegate=" + String.valueOf(this.delegate) + "]";
        }
    }

    private static final class FunctionTimerWrapper
    implements FunctionTimer {
        private final FunctionTimer delegate;
        private final Cleaner.Cleanable cleanable;

        private FunctionTimerWrapper(FunctionTimer delegate) {
            this.delegate = delegate;
            this.cleanable = CLEANER.register(this, new State((Meter)delegate));
        }

        public Meter.Id getId() {
            return this.delegate.getId();
        }

        public void close() {
            this.delegate.close();
            this.cleanable.clean();
        }

        public double count() {
            return this.delegate.count();
        }

        public double totalTime(TimeUnit unit) {
            return this.delegate.totalTime(unit);
        }

        public TimeUnit baseTimeUnit() {
            return this.delegate.baseTimeUnit();
        }
    }

    private static final class FunctionCounterWrapper
    implements FunctionCounter {
        private final FunctionCounter delegate;
        private final Cleaner.Cleanable cleanable;

        private FunctionCounterWrapper(FunctionCounter delegate) {
            this.delegate = delegate;
            this.cleanable = CLEANER.register(this, new State((Meter)delegate));
        }

        public double count() {
            return this.delegate.count();
        }

        public Meter.Id getId() {
            return this.delegate.getId();
        }

        public void close() {
            this.delegate.close();
            this.cleanable.clean();
        }
    }

    private static final class CounterWrapper
    implements Counter {
        private final Counter delegate;
        private final Cleaner.Cleanable cleanable;

        private CounterWrapper(Counter delegate) {
            this.delegate = delegate;
            this.cleanable = CLEANER.register(this, new State((Meter)delegate));
        }

        public Meter.Id getId() {
            return this.delegate.getId();
        }

        public void close() {
            this.delegate.close();
            this.cleanable.clean();
        }

        public void increment(double amount) {
            this.delegate.increment(amount);
        }

        public double count() {
            return this.delegate.count();
        }
    }

    private static final class TimerWrapper
    implements Timer {
        private final Timer delegate;
        private final Cleaner.Cleanable cleanable;

        private TimerWrapper(Timer delegate) {
            this.delegate = delegate;
            this.cleanable = CLEANER.register(this, new State((Meter)delegate));
        }

        public void record(long amount, TimeUnit unit) {
            this.delegate.record(amount, unit);
        }

        public <T> T record(Supplier<T> f) {
            return (T)this.delegate.record(f);
        }

        public <T> T recordCallable(Callable<T> f) throws Exception {
            return (T)this.delegate.recordCallable(f);
        }

        public void record(Runnable f) {
            this.delegate.record(f);
        }

        public long count() {
            return this.delegate.count();
        }

        public double totalTime(TimeUnit unit) {
            return this.delegate.totalTime(unit);
        }

        public double max(TimeUnit unit) {
            return this.delegate.max(unit);
        }

        public TimeUnit baseTimeUnit() {
            return this.delegate.baseTimeUnit();
        }

        public HistogramSnapshot takeSnapshot() {
            return this.delegate.takeSnapshot();
        }

        public Meter.Id getId() {
            return this.delegate.getId();
        }

        public void close() {
            this.delegate.close();
            this.cleanable.clean();
        }
    }

    private record State(Meter meter) implements Runnable
    {
        @Override
        public void run() {
            Metrics.globalRegistry.remove(this.meter);
        }
    }
}

