/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.UUID;

public enum DefaultValueGenerator {
    RAND_UUID("randUuid", UUID.class);

    private final MethodHandle methodHandle;

    private DefaultValueGenerator(String methodName, Class<?> resultCls) {
        try {
            this.methodHandle = MethodHandles.lookup().findStatic(DefaultValueGenerator.class, methodName, MethodType.methodType(resultCls));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object next() {
        try {
            return this.methodHandle.invoke();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static UUID randUuid() {
        return UUID.randomUUID();
    }
}

