/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

class MetaStorageServiceContext
implements ManuallyCloseable {
    private final RaftGroupService raftService;
    private final MetaStorageCommandsFactory commandsFactory;
    private final ExecutorService executorService;
    private final IgniteSpinBusyLock busyLock;

    MetaStorageServiceContext(RaftGroupService raftService, MetaStorageCommandsFactory commandsFactory, ExecutorService executorService, IgniteSpinBusyLock busyLock) {
        this.raftService = raftService;
        this.commandsFactory = commandsFactory;
        this.executorService = executorService;
        this.busyLock = busyLock;
    }

    RaftGroupService raftService() {
        return this.raftService;
    }

    MetaStorageCommandsFactory commandsFactory() {
        return this.commandsFactory;
    }

    ExecutorService executorService() {
        return this.executorService;
    }

    IgniteSpinBusyLock busyLock() {
        return this.busyLock;
    }

    @Override
    public void close() {
        IgniteUtils.shutdownAndAwaitTermination(this.executorService, 10L, TimeUnit.SECONDS);
        this.raftService.shutdown();
    }
}

