/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.CompactionRevisionUpdateListener;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.RevisionUpdateListener;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.exceptions.CompactedException;
import org.apache.ignite.internal.metastorage.impl.EntryImpl;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.KeyValueStorageUtils;
import org.apache.ignite.internal.metastorage.server.KeyValueUpdateContext;
import org.apache.ignite.internal.metastorage.server.NotifyWatchProcessorEvent;
import org.apache.ignite.internal.metastorage.server.ReadOperationForCompactionTracker;
import org.apache.ignite.internal.metastorage.server.RecoveryRevisionsListener;
import org.apache.ignite.internal.metastorage.server.UpdateCompactionRevisionEvent;
import org.apache.ignite.internal.metastorage.server.Value;
import org.apache.ignite.internal.metastorage.server.Watch;
import org.apache.ignite.internal.metastorage.server.WatchProcessor;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractKeyValueStorage
implements KeyValueStorage {
    protected static final Comparator<byte[]> KEY_COMPARATOR = Arrays::compareUnsigned;
    protected final IgniteLogger log = Loggers.forClass(this.getClass());
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final FailureManager failureManager;
    protected final WatchProcessor watchProcessor;
    @Nullable
    private RecoveryRevisionsListener recoveryRevisionListener;
    protected long rev;
    protected long compactionRevision = -1L;
    private volatile long planedUpdateCompactionRevision = -1L;
    protected final AtomicBoolean stopCompaction = new AtomicBoolean();
    protected final ReadOperationForCompactionTracker readOperationForCompactionTracker;
    @Nullable
    protected TreeSet<NotifyWatchProcessorEvent> notifyWatchProcessorEventsBeforeStartingWatches = new TreeSet();

    protected AbstractKeyValueStorage(String nodeName, FailureManager failureManager, ReadOperationForCompactionTracker readOperationForCompactionTracker) {
        this.failureManager = failureManager;
        this.readOperationForCompactionTracker = readOperationForCompactionTracker;
        this.watchProcessor = new WatchProcessor(nodeName, this::get, failureManager);
        this.watchProcessor.registerCompactionRevisionUpdateListener(this::setCompactionRevision);
    }

    protected abstract long[] keyRevisionsForOperation(byte[] var1);

    protected abstract Value valueForOperation(byte[] var1, long var2);

    private boolean isInRecoveryState() {
        return this.recoveryRevisionListener != null;
    }

    protected abstract boolean areWatchesStarted();

    @Override
    public Entry get(byte[] key) {
        this.rwLock.readLock().lock();
        try {
            Entry entry = this.doGet(key, this.rev);
            return entry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry get(byte[] key, long revUpperBound) {
        this.rwLock.readLock().lock();
        try {
            Entry entry = this.doGet(key, revUpperBound);
            return entry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Entry> get(byte[] key, long revLowerBound, long revUpperBound) {
        this.rwLock.readLock().lock();
        try {
            List<Entry> list = this.doGet(key, revLowerBound, revUpperBound);
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public List<Entry> getAll(List<byte[]> keys) {
        this.rwLock.readLock().lock();
        try {
            List<Entry> list = this.doGetAll(keys, this.rev);
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Entry> getAll(List<byte[]> keys, long revUpperBound) {
        this.rwLock.readLock().lock();
        try {
            List<Entry> list = this.doGetAll(keys, revUpperBound);
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public long revision() {
        this.rwLock.readLock().lock();
        try {
            long l = this.rev;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCompactionRevision(long revision, KeyValueUpdateContext context) {
        assert (revision >= 0L) : revision;
        this.rwLock.writeLock().lock();
        try {
            KeyValueStorageUtils.assertCompactionRevisionLessThanCurrent(revision, this.rev);
            this.saveCompactionRevision(revision, context, true);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    protected abstract void saveCompactionRevision(long var1, KeyValueUpdateContext var3, boolean var4);

    @Override
    public void setCompactionRevision(long revision) {
        assert (revision >= 0L) : revision;
        this.rwLock.writeLock().lock();
        try {
            KeyValueStorageUtils.assertCompactionRevisionLessThanCurrent(revision, this.rev);
            this.compactionRevision = revision;
            this.notifyRevisionsUpdate();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public long getCompactionRevision() {
        this.rwLock.readLock().lock();
        try {
            long l = this.compactionRevision;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCompactionRevision(long compactionRevision, KeyValueUpdateContext context) {
        assert (compactionRevision >= 0L) : compactionRevision;
        this.rwLock.writeLock().lock();
        try {
            KeyValueStorageUtils.assertCompactionRevisionLessThanCurrent(compactionRevision, this.rev);
            this.saveCompactionRevision(compactionRevision, context, false);
            if (this.isInRecoveryState()) {
                this.setCompactionRevision(compactionRevision);
            } else if (this.areWatchesStarted()) {
                if (compactionRevision > this.planedUpdateCompactionRevision) {
                    this.planedUpdateCompactionRevision = compactionRevision;
                    this.watchProcessor.updateCompactionRevision(compactionRevision, context.timestamp);
                } else {
                    this.watchProcessor.advanceSafeTime(context.timestamp);
                }
            } else if (compactionRevision > this.planedUpdateCompactionRevision) {
                this.planedUpdateCompactionRevision = compactionRevision;
                UpdateCompactionRevisionEvent notifyWatchesEvent = new UpdateCompactionRevisionEvent(compactionRevision, context.timestamp);
                this.addToNotifyWatchProcessorEventsBeforeStartingWatches(notifyWatchesEvent);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void stopCompaction() {
        this.stopCompaction.set(true);
    }

    @Override
    public byte @Nullable [] nextKey(byte[] key) {
        return RocksUtils.incrementPrefix((byte[])key);
    }

    @Override
    public void registerRevisionUpdateListener(RevisionUpdateListener listener) {
        this.watchProcessor.registerRevisionUpdateListener(listener);
    }

    @Override
    public void unregisterRevisionUpdateListener(RevisionUpdateListener listener) {
        this.watchProcessor.unregisterRevisionUpdateListener(listener);
    }

    @Override
    public CompletableFuture<Void> notifyRevisionUpdateListenerOnStart(long newRevision) {
        return this.watchProcessor.notifyUpdateRevisionListeners(newRevision);
    }

    @Override
    public void registerCompactionRevisionUpdateListener(CompactionRevisionUpdateListener listener) {
        this.watchProcessor.registerCompactionRevisionUpdateListener(listener);
    }

    @Override
    public void unregisterCompactionRevisionUpdateListener(CompactionRevisionUpdateListener listener) {
        this.watchProcessor.unregisterCompactionRevisionUpdateListener(listener);
    }

    @Override
    public void setRecoveryRevisionsListener(@Nullable RecoveryRevisionsListener listener) {
        this.rwLock.writeLock().lock();
        try {
            this.recoveryRevisionListener = listener;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void removeWatch(WatchListener listener) {
        this.watchProcessor.removeWatch(listener);
    }

    @Override
    public void watchRange(byte[] keyFrom, byte @Nullable [] keyTo, long rev, WatchListener listener) {
        assert (rev > 0L) : rev;
        Predicate<byte[]> rangePredicate = keyTo == null ? k -> KEY_COMPARATOR.compare(keyFrom, (byte[])k) <= 0 : k -> KEY_COMPARATOR.compare(keyFrom, (byte[])k) <= 0 && KEY_COMPARATOR.compare(keyTo, (byte[])k) > 0;
        this.watchProcessor.addWatch(new Watch(rev, listener, rangePredicate));
    }

    @Override
    public void watchExact(Collection<byte[]> keys, long rev, WatchListener listener) {
        assert (rev > 0L) : rev;
        assert (!keys.isEmpty());
        TreeSet<byte[]> keySet = new TreeSet<byte[]>(KEY_COMPARATOR);
        keySet.addAll(keys);
        Predicate<byte[]> inPredicate = keySet::contains;
        this.watchProcessor.addWatch(new Watch(rev, listener, inPredicate));
    }

    @Override
    public void watchExact(byte[] key, long rev, WatchListener listener) {
        assert (rev > 0L) : rev;
        Predicate<byte[]> exactPredicate = k -> KEY_COMPARATOR.compare((byte[])k, key) == 0;
        this.watchProcessor.addWatch(new Watch(rev, listener, exactPredicate));
    }

    protected void notifyRevisionsUpdate() {
        if (this.recoveryRevisionListener != null) {
            this.recoveryRevisionListener.onUpdate(this.createCurrentRevisions());
        }
    }

    protected Entry doGet(byte[] key, long revUpperBound) {
        assert (revUpperBound >= 0L) : revUpperBound;
        long[] keyRevisions = this.keyRevisionsForOperation(key);
        int maxRevisionIndex = KeyValueStorageUtils.maxRevisionIndex(keyRevisions, revUpperBound);
        if (maxRevisionIndex == -1) {
            CompactedException.throwIfRequestedRevisionLessThanOrEqualToCompacted((long)revUpperBound, (long)this.compactionRevision);
            return EntryImpl.empty(key);
        }
        long revision = keyRevisions[maxRevisionIndex];
        Value value = this.valueForOperation(key, revision);
        if (revUpperBound <= this.compactionRevision && (!KeyValueStorageUtils.isLastIndex(keyRevisions, maxRevisionIndex) || value.tombstone())) {
            throw new CompactedException(revUpperBound, this.compactionRevision);
        }
        return EntryImpl.toEntry(key, revision, value);
    }

    private List<Entry> doGet(byte[] key, long revLowerBound, long revUpperBound) {
        assert (revLowerBound >= 0L) : revLowerBound;
        assert (revUpperBound >= 0L) : revUpperBound;
        assert (revUpperBound >= revLowerBound) : "revLowerBound=" + revLowerBound + ", revUpperBound=" + revUpperBound;
        long[] keyRevisions = this.keyRevisionsForOperation(key);
        int minRevisionIndex = KeyValueStorageUtils.minRevisionIndex(keyRevisions, revLowerBound);
        int maxRevisionIndex = KeyValueStorageUtils.maxRevisionIndex(keyRevisions, revUpperBound);
        if (minRevisionIndex == -1 || maxRevisionIndex == -1) {
            CompactedException.throwIfRequestedRevisionLessThanOrEqualToCompacted((long)revLowerBound, (long)this.compactionRevision);
            return List.of();
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = minRevisionIndex; i <= maxRevisionIndex; ++i) {
            Value value;
            long revision = keyRevisions[i];
            if (revision <= this.compactionRevision) {
                if (!KeyValueStorageUtils.isLastIndex(keyRevisions, i) || (value = this.valueForOperation(key, revision)).tombstone()) {
                    continue;
                }
            } else {
                value = this.valueForOperation(key, revision);
            }
            entries.add(EntryImpl.toEntry(key, revision, value));
        }
        if (entries.isEmpty()) {
            CompactedException.throwIfRequestedRevisionLessThanOrEqualToCompacted((long)revLowerBound, (long)this.compactionRevision);
        }
        return entries;
    }

    private List<Entry> doGetAll(List<byte[]> keys, long revUpperBound) {
        assert (!keys.isEmpty());
        assert (revUpperBound >= 0L) : revUpperBound;
        ArrayList<Entry> res = new ArrayList<Entry>(keys.size());
        for (byte[] key : keys) {
            res.add(this.doGet(key, revUpperBound));
        }
        return res;
    }

    @Override
    public void advanceSafeTime(KeyValueUpdateContext context) {
        this.rwLock.writeLock().lock();
        try {
            this.setIndexAndTerm(context.index, context.term);
            if (this.areWatchesStarted()) {
                this.watchProcessor.advanceSafeTime(context.timestamp);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public Revisions revisions() {
        this.rwLock.readLock().lock();
        try {
            Revisions revisions = this.createCurrentRevisions();
            return revisions;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private Revisions createCurrentRevisions() {
        return new Revisions(this.rev, this.compactionRevision);
    }

    protected void addToNotifyWatchProcessorEventsBeforeStartingWatches(NotifyWatchProcessorEvent event) {
        assert (!this.areWatchesStarted());
        boolean added = this.notifyWatchProcessorEventsBeforeStartingWatches.add(event);
        assert (added) : event;
    }

    protected void drainNotifyWatchProcessorEventsBeforeStartingWatches() {
        assert (!this.areWatchesStarted());
        this.notifyWatchProcessorEventsBeforeStartingWatches.forEach(event -> event.notify(this.watchProcessor));
        this.notifyWatchProcessorEventsBeforeStartingWatches = null;
    }
}

