/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingTransaction
implements InternalTransaction,
Wrapper {
    private final InternalTransaction transaction;
    private final Executor asyncContinuationExecutor;

    PublicApiThreadingTransaction(Transaction transaction, Executor asyncContinuationExecutor) {
        this.transaction = (InternalTransaction)transaction;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public void commit() throws TransactionException {
        PublicApiThreading.execUserSyncOperation(() -> ((InternalTransaction)this.transaction).commit());
    }

    public CompletableFuture<Void> commitAsync() {
        return this.preventThreadHijack(() -> ((InternalTransaction)this.transaction).commitAsync());
    }

    public void rollback() throws TransactionException {
        PublicApiThreading.execUserSyncOperation(() -> ((InternalTransaction)this.transaction).rollback());
    }

    public CompletableFuture<Void> rollbackAsync() {
        return this.preventThreadHijack(() -> ((InternalTransaction)this.transaction).rollbackAsync());
    }

    public boolean isReadOnly() {
        return this.transaction.isReadOnly();
    }

    private <T> CompletableFuture<T> preventThreadHijack(Supplier<CompletableFuture<T>> operation) {
        CompletableFuture future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack((CompletableFuture)future, (Executor)this.asyncContinuationExecutor);
    }

    @Override
    public UUID id() {
        return this.transaction.id();
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlistedNodeAndConsistencyToken(TablePartitionId tablePartitionId) {
        return this.transaction.enlistedNodeAndConsistencyToken(tablePartitionId);
    }

    @Override
    public TxState state() {
        return this.transaction.state();
    }

    @Override
    public boolean assignCommitPartition(TablePartitionId tablePartitionId) {
        return this.transaction.assignCommitPartition(tablePartitionId);
    }

    @Override
    public TablePartitionId commitPartition() {
        return this.transaction.commitPartition();
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlist(TablePartitionId tablePartitionId, IgniteBiTuple<ClusterNode, Long> nodeAndConsistencyToken) {
        return this.transaction.enlist(tablePartitionId, nodeAndConsistencyToken);
    }

    @Override
    @Nullable
    public HybridTimestamp readTimestamp() {
        return this.transaction.readTimestamp();
    }

    @Override
    public HybridTimestamp startTimestamp() {
        return this.transaction.startTimestamp();
    }

    @Override
    public UUID coordinatorId() {
        return this.transaction.coordinatorId();
    }

    @Override
    public boolean implicit() {
        return this.transaction.implicit();
    }

    @Override
    public CompletableFuture<Void> finish(boolean commit, HybridTimestamp executionTimestamp, boolean full) {
        return this.transaction.finish(commit, executionTimestamp, full);
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.transaction.isFinishingOrFinished();
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.transaction);
    }
}

